% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.arrangement}
\alias{kernel.arrangement}
\title{Functional arrangement of kernel density hypervolumes.}
\usage{
kernel.arrangement(
  comm,
  stat = "rneig",
  distance = seq(0, 1, 0.01),
  pool = NULL,
  type = "SES",
  alpha = 0.05,
  runs = 99,
  plotValues = TRUE
)
}
\arguments{
\item{comm}{A 'Hypervolume' object, preferably built using function kernel.build.}

\item{stat}{statistic to be calculated. One of c("rneig", "nnpair"), meaning "nearest neighbor" and "all neighbors" respectively.}

\item{distance}{vector of distances to be considered in calculations}

\item{pool}{Species pool coordinates to use for null model construction.
When \code{NULL} (default), the function performs a random displacement null model using the environmental space defined in the hypervolume object.
When specified (typically coordinates from \code{hyper.build} output), the function instead performs a random selection null model, drawing species randomly from the provided pool coordinates.
Must be a matrix or data.frame of coordinates matching the hypervolume dimensions.}

\item{type}{Envelope type for testing significance. One of c("ecdf", "norm", "SES"), meaning "empirical cumulative distribution", "normalized envelope" (between 0-1, 0.5 indicate randomness, more than 0.5 - clustered; less than 0.5 - inhibition), and "standardized effect size" respectively.}

\item{alpha}{alpha value to consider in significance testing (p-value).}

\item{runs}{number of simulations for significance testing.}

\item{plotValues}{Whether to plot "rneig" or "nnpair" values for all distances.}
}
\value{
A list with observed rneig or nnpair values, the confidence limits and standard effect size.
}
\description{
Functional arrangement of a community, measuring the distribution of stochastic points within the total functional space at different distances.
}
\details{
This function measures the functional arrangement (Carvalho & Cardoso, subm.) of a n-dimensional hypervolume, namely the distribution of stochastic points within the total trait space from small to large functional distances.
}
\examples{
\dontrun{
comm = c(100,3,0,5,3)
names(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")

trait = data.frame(body = c(1,2,3,4,2), beak = c(1,5,4,1,2))
rownames(trait) = names(comm)

hv = kernel.build(comm, trait, method.hv = "svm", svm.nu = 0.01, svm.gamma = 0.25)
kernel.arrangement(hv)
}
}
\references{
Carvalho, J.C. & Cardoso, P. (subm.) Quantifying species distribution within the functional space.
}
