% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Pop.R
\name{newMegaPop}
\alias{newMegaPop}
\title{Create new Mega Population}
\usage{
newMegaPop(...)
}
\arguments{
\item{...}{one or more \code{\link{Pop-class}} and/or 
\code{\link{MegaPop-class}} objects.}
}
\value{
Returns an object of \code{\link{MegaPop-class}}
}
\description{
Creates a new \code{\link{MegaPop-class}} from one or more
\code{\link{Pop-class}} and/or \code{\link{MegaPop-class}} 
objects.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)
megaPop = newMegaPop(pop=pop)

}
