% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1_plot_PI.R
\name{step1_plot_PI}
\alias{step1_plot_PI}
\title{Plot Prediction Intervals}
\usage{
step1_plot_PI(
  step1_down_object,
  xname = NULL,
  yname = NULL,
  xlim = NULL,
  ylim = NULL,
  ribbon = FALSE
)
}
\arguments{
\item{step1_down_object}{The fit object from the step1.down function (required).}

\item{xname}{Label for the x-axis (optional).}

\item{yname}{Label for the y-axis (optional).}

\item{xlim}{x-axis limits (optional).}

\item{ylim}{y-axis limits (optional).}

\item{ribbon}{Add shade to prediction intervals (optional).}
}
\value{
Plot of stability data with prediction curves and prediction intervals.
}
\description{
Plot the stability data and visualise the predictions with prediction intervals.
}
\details{
Use the fit object obtained from the step1.down function to plot the
stability data and visualise the predictions with prediction intervals applied.
There is an option to view the prediction intervals as a ribbon. The
prediction interval value is chosen in the step1.down function.
}
\examples{
#Load antigenicity data
data(antigenicity)

#Run step1.down fit
fit1 <- step1_down(data = antigenicity, y = "conc", .time = "time",
 C = "Celsius", max_time_pred = 3)

#Plot raw data with prediction curves and prediction intervals.
step1_plot_PI(step1_down_object = fit1, xlim = NULL, ylim = NULL,
 xname = "Time (Years)", yname = "Concentration", ribbon = TRUE)

#Plot raw data with prediction curves and confidence intervals.
#Also limit x-axis to values between 0 and 1.5 and limit y-axis to values between 0 and 105.
step1_plot_PI(step1_down_object = fit1, xlim = c(0,1.5), ylim = c(0,105),
 xname = "Time (Years)", yname = "Concentration", ribbon = TRUE)

}
