% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgstats.R
\name{pkgstats}
\alias{pkgstats}
\title{Collates statistics from one local tarball}
\usage{
pkgstats(path = ".")
}
\arguments{
\item{path}{Either a path to a local source repository, or a local '.tar.gz'
file containing code for an R package.}
}
\value{
List of statistics and data on function call networks (or object
relationships in other languages). Includes the following components:
\enumerate{
\item{loc: }{Summary of Lines-of-Code in all package directories}
\item{vignettes: }{Numbers of vignettes and "demo" files}
\item{data_stats: }{Statistics of numbers and sizes of package data files}
\item{desc: }{Summary of contents of 'DESCRIPTION' file}
\item{translations: }{List of translations into other (human) languages
(where provides)}
\item{objects: }{A \code{data.frame} of all functions in R, and all other
objects (functions, classes, structures, global variables, and more) in all
other languages}
\item{network: }{A \code{data.frame} of object references within and between all
languages; in R these are function calls, but may be more abstract in other
languages.}
\item{external_calls: }{A \code{data.frame} of all calls make to all functions
from all other R packages, including base and recommended as well as
contributed packages.}
}
}
\description{
Collates statistics from one local tarball
}
\examples{
\dontrun{
tarball <- "magrittr_2.0.1.tar.gz"
u <- paste0 (
    "https://cran.r-project.org/src/contrib/",
    tarball
)
f <- file.path (tempdir (), tarball)
download.file (u, f)
pkgstats (f)
}
}
\seealso{
Other stats: 
\code{\link{desc_stats}()},
\code{\link{loc_stats}()},
\code{\link{pkgstats_summary}()},
\code{\link{rd_stats}()}
}
\concept{stats}
