/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.math3.stat.Frequency;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataRecordIteration;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.statistics.DescriptiveStatisticsDummy;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGUtils;
import org.vikamine.kernel.subgroup.selectors.SGSelector;

public class DataView
implements Iterable<DataRecord> {
    private final IDataRecordSet drs;
    private final List<SGSelector> populationRangesSelectors;
    private final HashMap<Attribute, Frequency> frequencyMap;
    private final HashMap<Attribute, DescriptiveStatisticsDummy> numericStatsMap;
    private DataRecordIteration instanceIteration;

    public DataView(IDataRecordSet theInstances, List<SGSelector> populationRangesSelectors) {
        this.drs = theInstances;
        this.populationRangesSelectors = populationRangesSelectors;
        this.frequencyMap = new HashMap();
        this.numericStatsMap = new HashMap();
        this.init();
    }

    public DataView createPopulation(List<SGSelector> rangeSelectors) {
        return new DataView(this.drs, rangeSelectors);
    }

    public IDataRecordSet dataset() {
        return this.drs;
    }

    private void init() {
        if (this.populationRangesSelectors == null || this.populationRangesSelectors.isEmpty()) {
            this.instanceIteration = new DataRecordIteration(this.drs);
        } else {
            DataViewRecordIterator iter = new DataViewRecordIterator(this.drs, this.populationRangesSelectors);
            this.instanceIteration = new DataRecordIteration(iter);
        }
    }

    public Iterator<DataRecord> instanceIterator() {
        return this.instanceIteration.iterator();
    }

    public List<SGSelector> populationRangesSelectors() {
        return new ArrayList<SGSelector>(this.populationRangesSelectors);
    }

    public int size() {
        return this.instanceIteration.size();
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return this.instanceIterator();
    }

    public DescriptiveStatisticsDummy getStatsForAttribute(NumericAttribute att) {
        DescriptiveStatisticsDummy stat = this.numericStatsMap.get(att);
        if (stat == null) {
            stat = new DescriptiveStatisticsDummy(SGUtils.createDescriptiveStats(this, att));
            this.numericStatsMap.put(att, stat);
        }
        return stat;
    }

    public Frequency getFrequenciesForAttribute(Attribute att) {
        Frequency stat = this.frequencyMap.get(att);
        if (stat == null) {
            stat = SGUtils.createFrequencyStats(this, att);
            this.frequencyMap.put(att, stat);
        }
        return stat;
    }

    private static class DataViewRecordIterator
    implements Iterator<DataRecord> {
        private final IDataRecordSet instances;
        private int counter = 0;
        private int size = 0;
        private boolean applyFilter;
        private DataRecord nextInstance;
        private SGDescription populationRangesFilteringSGDescription;

        public DataViewRecordIterator(IDataRecordSet instances, List<SGSelector> populationRangesSelectors) {
            this.instances = instances;
            this.size = instances.getNumInstances();
            if (populationRangesSelectors == null || populationRangesSelectors.isEmpty()) {
                this.applyFilter = false;
            } else {
                this.applyFilter = true;
                this.populationRangesFilteringSGDescription = new SGDescription();
                for (SGSelector sel : populationRangesSelectors) {
                    this.populationRangesFilteringSGDescription.add(sel);
                }
            }
        }

        @Override
        public boolean hasNext() {
            while (this.nextInstance == null && this.counter < this.size) {
                DataRecord instance = this.instances.get(this.counter);
                if (!this.applyFilter || this.populationRangesFilteringSGDescription.isMatching(instance)) {
                    this.nextInstance = instance;
                }
                ++this.counter;
            }
            return this.nextInstance != null;
        }

        @Override
        public DataRecord next() {
            if (this.hasNext()) {
                DataRecord instance = this.nextInstance;
                assert (instance != null);
                this.nextInstance = null;
                return instance;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("DataViewRecordIterator can not remove Elements!");
        }
    }
}

