/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.trees.REPTree;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class Bagging
extends RandomizableIteratedSingleClassifierEnhancer
implements WeightedInstancesHandler,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = -5178288489778728847L;
    protected int m_BagSizePercent = 100;
    protected boolean m_CalcOutOfBag = false;
    protected double m_OutOfBagError;

    public Bagging() {
        this.m_Classifier = new REPTree();
    }

    public String globalInfo() {
        return "Class for bagging a classifier to reduce variance. Can do classification and regression depending on the base learner. \n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Leo Breiman");
        result.setValue(TechnicalInformation.Field.YEAR, "1996");
        result.setValue(TechnicalInformation.Field.TITLE, "Bagging predictors");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "24");
        result.setValue(TechnicalInformation.Field.NUMBER, "2");
        result.setValue(TechnicalInformation.Field.PAGES, "123-140");
        return result;
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.REPTree";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tSize of each bag, as a percentage of the\n\ttraining set size. (default 100)", "P", 1, "-P"));
        newVector.addElement(new Option("\tCalculate the out of bag error.", "O", 0, "-O"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String bagSize = Utils.getOption('P', options);
        if (bagSize.length() != 0) {
            this.setBagSizePercent(Integer.parseInt(bagSize));
        } else {
            this.setBagSizePercent(100);
        }
        this.setCalcOutOfBag(Utils.getFlag('O', options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 3];
        int current = 0;
        options[current++] = "-P";
        options[current++] = "" + this.getBagSizePercent();
        if (this.getCalcOutOfBag()) {
            options[current++] = "-O";
        }
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        current += superOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String bagSizePercentTipText() {
        return "Size of each bag, as a percentage of the training set size.";
    }

    public int getBagSizePercent() {
        return this.m_BagSizePercent;
    }

    public void setBagSizePercent(int newBagSizePercent) {
        this.m_BagSizePercent = newBagSizePercent;
    }

    public String calcOutOfBagTipText() {
        return "Whether the out-of-bag error is calculated.";
    }

    public void setCalcOutOfBag(boolean calcOutOfBag) {
        this.m_CalcOutOfBag = calcOutOfBag;
    }

    public boolean getCalcOutOfBag() {
        return this.m_CalcOutOfBag;
    }

    public double measureOutOfBagError() {
        return this.m_OutOfBagError;
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureOutOfBagError");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.equalsIgnoreCase("measureOutOfBagError")) {
            return this.measureOutOfBagError();
        }
        throw new IllegalArgumentException(String.valueOf(additionalMeasureName) + " not supported (Bagging)");
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        super.buildClassifier(data);
        if (this.m_CalcOutOfBag && this.m_BagSizePercent != 100) {
            throw new IllegalArgumentException("Bag size needs to be 100% if out-of-bag error is to be calculated!");
        }
        int bagSize = data.numInstances() * this.m_BagSizePercent / 100;
        Random random = new Random(this.m_Seed);
        boolean[][] inBag = null;
        if (this.m_CalcOutOfBag) {
            inBag = new boolean[this.m_Classifiers.length][];
        }
        int j = 0;
        while (j < this.m_Classifiers.length) {
            Instances bagData = null;
            if (this.m_CalcOutOfBag) {
                inBag[j] = new boolean[data.numInstances()];
                bagData = data.resampleWithWeights(random, inBag[j]);
            } else {
                bagData = data.resampleWithWeights(random);
                if (bagSize < data.numInstances()) {
                    Instances newBagData;
                    bagData.randomize(random);
                    bagData = newBagData = new Instances(bagData, 0, bagSize);
                }
            }
            if (this.m_Classifier instanceof Randomizable) {
                ((Randomizable)((Object)this.m_Classifiers[j])).setSeed(random.nextInt());
            }
            this.m_Classifiers[j].buildClassifier(bagData);
            ++j;
        }
        if (this.getCalcOutOfBag()) {
            double outOfBagCount = 0.0;
            double errorSum = 0.0;
            boolean numeric = data.classAttribute().isNumeric();
            int i = 0;
            while (i < data.numInstances()) {
                double vote;
                double[] votes = numeric ? new double[1] : new double[data.numClasses()];
                int voteCount = 0;
                int j2 = 0;
                while (j2 < this.m_Classifiers.length) {
                    if (!inBag[j2][i]) {
                        ++voteCount;
                        if (numeric) {
                            votes[0] = this.m_Classifiers[j2].classifyInstance(data.instance(i));
                        } else {
                            double[] newProbs = this.m_Classifiers[j2].distributionForInstance(data.instance(i));
                            int k = 0;
                            while (k < newProbs.length) {
                                int n = k;
                                votes[n] = votes[n] + newProbs[k];
                                ++k;
                            }
                        }
                    }
                    ++j2;
                }
                if (numeric) {
                    vote = votes[0];
                    if (voteCount > 0) {
                        vote /= (double)voteCount;
                    }
                } else {
                    if (!Utils.eq(Utils.sum(votes), 0.0)) {
                        Utils.normalize(votes);
                    }
                    vote = Utils.maxIndex(votes);
                }
                outOfBagCount += data.instance(i).weight();
                if (numeric) {
                    errorSum += StrictMath.abs(vote - data.instance(i).classValue()) * data.instance(i).weight();
                } else if (vote != data.instance(i).classValue()) {
                    errorSum += data.instance(i).weight();
                }
                ++i;
            }
            this.m_OutOfBagError = errorSum / outOfBagCount;
        } else {
            this.m_OutOfBagError = 0.0;
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] sums = new double[instance.numClasses()];
        int i = 0;
        while (i < this.m_NumIterations) {
            if (instance.classAttribute().isNumeric()) {
                sums[0] = sums[0] + this.m_Classifiers[i].classifyInstance(instance);
            } else {
                double[] newProbs = this.m_Classifiers[i].distributionForInstance(instance);
                int j = 0;
                while (j < newProbs.length) {
                    int n = j;
                    sums[n] = sums[n] + newProbs[j];
                    ++j;
                }
            }
            ++i;
        }
        if (instance.classAttribute().isNumeric()) {
            sums[0] = sums[0] / (double)this.m_NumIterations;
            return sums;
        }
        if (Utils.eq(Utils.sum(sums), 0.0)) {
            return sums;
        }
        Utils.normalize(sums);
        return sums;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "Bagging: No model built yet.";
        }
        StringBuffer text = new StringBuffer();
        text.append("All the base classifiers: \n\n");
        int i = 0;
        while (i < this.m_Classifiers.length) {
            text.append(String.valueOf(this.m_Classifiers[i].toString()) + "\n\n");
            ++i;
        }
        if (this.m_CalcOutOfBag) {
            text.append("Out of bag error: " + Utils.doubleToString(this.m_OutOfBagError, 4) + "\n\n");
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9370 $");
    }

    public static void main(String[] argv) {
        Bagging.runClassifier(new Bagging(), argv);
    }
}

