/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SpecialFunctions;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class NaiveBayesMultinomial
extends Classifier
implements WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 5932177440181257085L;
    protected double[][] m_probOfWordGivenClass;
    protected double[] m_probOfClass;
    protected int m_numAttributes;
    protected int m_numClasses;
    protected double[] m_lnFactorialCache = new double[]{0.0, 0.0};
    protected Instances m_headerInfo;

    public String globalInfo() {
        return "Class for building and using a multinomial Naive Bayes classifier. For more information see,\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "The core equation for this classifier:\n\n" + "P[Ci|D] = (P[D|Ci] x P[Ci]) / P[D] (Bayes rule)\n\n" + "where Ci is class i and D is a document.";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Andrew Mccallum and Kamal Nigam");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "A Comparison of Event Models for Naive Bayes Text Classification");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "AAAI-98 Workshop on 'Learning for Text Categorization'");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_headerInfo = new Instances(instances, 0);
        this.m_numClasses = instances.numClasses();
        this.m_numAttributes = instances.numAttributes();
        this.m_probOfWordGivenClass = new double[this.m_numClasses][];
        int c = 0;
        while (c < this.m_numClasses) {
            this.m_probOfWordGivenClass[c] = new double[this.m_numAttributes];
            int att = 0;
            while (att < this.m_numAttributes) {
                this.m_probOfWordGivenClass[c][att] = 1.0;
                ++att;
            }
            ++c;
        }
        double[] docsPerClass = new double[this.m_numClasses];
        double[] wordsPerClass = new double[this.m_numClasses];
        Enumeration enumInsts = instances.enumerateInstances();
        while (enumInsts.hasMoreElements()) {
            int classIndex;
            Instance instance = (Instance)enumInsts.nextElement();
            int n = classIndex = (int)instance.value(instance.classIndex());
            docsPerClass[n] = docsPerClass[n] + instance.weight();
            int a = 0;
            while (a < instance.numValues()) {
                if (instance.index(a) != instance.classIndex() && !instance.isMissing(a)) {
                    double numOccurences = instance.valueSparse(a) * instance.weight();
                    if (numOccurences < 0.0) {
                        throw new Exception("Numeric attribute values must all be greater or equal to zero.");
                    }
                    int n2 = classIndex;
                    wordsPerClass[n2] = wordsPerClass[n2] + numOccurences;
                    double[] dArray = this.m_probOfWordGivenClass[classIndex];
                    int n3 = instance.index(a);
                    dArray[n3] = dArray[n3] + numOccurences;
                }
                ++a;
            }
        }
        int c2 = 0;
        while (c2 < this.m_numClasses) {
            int v = 0;
            while (v < this.m_numAttributes) {
                this.m_probOfWordGivenClass[c2][v] = Math.log(this.m_probOfWordGivenClass[c2][v] / (wordsPerClass[c2] + (double)this.m_numAttributes - 1.0));
                ++v;
            }
            ++c2;
        }
        double numDocs = instances.sumOfWeights() + (double)this.m_numClasses;
        this.m_probOfClass = new double[this.m_numClasses];
        int h = 0;
        while (h < this.m_numClasses) {
            this.m_probOfClass[h] = (docsPerClass[h] + 1.0) / numDocs;
            ++h;
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] probOfClassGivenDoc = new double[this.m_numClasses];
        double[] logDocGivenClass = new double[this.m_numClasses];
        int h = 0;
        while (h < this.m_numClasses) {
            logDocGivenClass[h] = this.probOfDocGivenClass(instance, h);
            ++h;
        }
        double max = logDocGivenClass[Utils.maxIndex(logDocGivenClass)];
        double probOfDoc = 0.0;
        int i = 0;
        while (i < this.m_numClasses) {
            probOfClassGivenDoc[i] = Math.exp(logDocGivenClass[i] - max) * this.m_probOfClass[i];
            probOfDoc += probOfClassGivenDoc[i];
            ++i;
        }
        Utils.normalize(probOfClassGivenDoc, probOfDoc);
        return probOfClassGivenDoc;
    }

    private double probOfDocGivenClass(Instance inst, int classIndex) {
        double answer = 0.0;
        int i = 0;
        while (i < inst.numValues()) {
            if (inst.index(i) != inst.classIndex()) {
                double freqOfWordInDoc = inst.valueSparse(i);
                answer += freqOfWordInDoc * this.m_probOfWordGivenClass[classIndex][inst.index(i)];
            }
            ++i;
        }
        return answer;
    }

    public double lnFactorial(int n) {
        if (n < 0) {
            return SpecialFunctions.lnFactorial(n);
        }
        if (this.m_lnFactorialCache.length <= n) {
            double[] tmp = new double[n + 1];
            System.arraycopy(this.m_lnFactorialCache, 0, tmp, 0, this.m_lnFactorialCache.length);
            int i = this.m_lnFactorialCache.length;
            while (i < tmp.length) {
                tmp[i] = tmp[i - 1] + Math.log(i);
                ++i;
            }
            this.m_lnFactorialCache = tmp;
        }
        return this.m_lnFactorialCache[n];
    }

    public String toString() {
        StringBuffer result = new StringBuffer("The independent probability of a class\n--------------------------------------\n");
        int c = 0;
        while (c < this.m_numClasses) {
            result.append(this.m_headerInfo.classAttribute().value(c)).append("\t").append(Double.toString(this.m_probOfClass[c])).append("\n");
            ++c;
        }
        result.append("\nThe probability of a word given the class\n-----------------------------------------\n\t");
        c = 0;
        while (c < this.m_numClasses) {
            result.append(this.m_headerInfo.classAttribute().value(c)).append("\t");
            ++c;
        }
        result.append("\n");
        int w = 0;
        while (w < this.m_numAttributes) {
            if (w != this.m_headerInfo.classIndex()) {
                result.append(this.m_headerInfo.attribute(w).name()).append("\t");
                int c2 = 0;
                while (c2 < this.m_numClasses) {
                    result.append(Double.toString(Math.exp(this.m_probOfWordGivenClass[c2][w]))).append("\t");
                    ++c2;
                }
                result.append("\n");
            }
            ++w;
        }
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6303 $");
    }

    public static void main(String[] argv) {
        NaiveBayesMultinomial.runClassifier(new NaiveBayesMultinomial(), argv);
    }
}

