/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.sat.MiniSat;

public interface SatFactory {
    public MiniSat _me();

    default public boolean addClause(int[] POSVARS, int[] NEGVARS) {
        TIntArrayList lits = new TIntArrayList(POSVARS.length + NEGVARS.length);
        for (int p : POSVARS) {
            lits.add(MiniSat.makeLiteral(p, true));
        }
        for (int n : NEGVARS) {
            lits.add(MiniSat.makeLiteral(n, false));
        }
        return this._me().addClause(lits);
    }

    default public boolean addTrue(int BOOLVAR) {
        int lit = MiniSat.makeLiteral(BOOLVAR, true);
        return this._me().addClause(lit);
    }

    default public boolean addFalse(int BOOLVAR) {
        int lit = MiniSat.makeLiteral(BOOLVAR, false);
        return this._me().addClause(lit);
    }

    default public boolean addBoolEq(int LEFT, int RIGHT) {
        int left_lit = MiniSat.makeLiteral(LEFT, true);
        int right_lit = MiniSat.makeLiteral(RIGHT, true);
        boolean add = this._me().addClause(MiniSat.neg(left_lit), right_lit);
        return add &= this._me().addClause(left_lit, MiniSat.neg(right_lit));
    }

    default public boolean addBoolLe(int LEFT, int RIGHT) {
        int left_lit = MiniSat.makeLiteral(LEFT, false);
        int right_lit = MiniSat.makeLiteral(RIGHT, true);
        return this._me().addClause(left_lit, right_lit);
    }

    default public boolean addBoolLt(int LEFT, int RIGHT) {
        int left_lit = MiniSat.makeLiteral(LEFT, false);
        int right_lit = MiniSat.makeLiteral(RIGHT, true);
        return this._me().addClause(right_lit) & this._me().addClause(left_lit, MiniSat.neg(right_lit));
    }

    default public boolean addBoolNot(int LEFT, int RIGHT) {
        int left_lit = MiniSat.makeLiteral(LEFT, true);
        int right_lit = MiniSat.makeLiteral(RIGHT, true);
        return this._me().addClause(MiniSat.neg(left_lit), MiniSat.neg(right_lit)) & this._me().addClause(left_lit, right_lit);
    }

    default public boolean addBoolOrArrayEqVar(int[] BOOLVARS, int TARGET) {
        int target_lit = MiniSat.makeLiteral(TARGET, true);
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length + 1);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            lits.add(MiniSat.makeLiteral(BOOLVARS[i], true));
        }
        lits.add(MiniSat.neg(target_lit));
        boolean add = this._me().addClause(lits);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            add &= this._me().addClause(target_lit, MiniSat.makeLiteral(BOOLVARS[i], false));
        }
        return add;
    }

    default public boolean addBoolAndArrayEqVar(int[] BOOLVARS, int TARGET) {
        int target_lit = MiniSat.makeLiteral(TARGET, true);
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length + 1);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            lits.add(MiniSat.makeLiteral(BOOLVARS[i], false));
        }
        lits.add(target_lit);
        boolean add = this._me().addClause(lits);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            add &= this._me().addClause(MiniSat.neg(target_lit), MiniSat.makeLiteral(BOOLVARS[i], true));
        }
        return add;
    }

    default public boolean addBoolOrEqVar(int LEFT, int RIGHT, int TARGET) {
        int left_lit = MiniSat.makeLiteral(LEFT, true);
        int right_lit = MiniSat.makeLiteral(RIGHT, true);
        int target_lit = MiniSat.makeLiteral(TARGET, true);
        boolean add = this._me().addClause(left_lit, right_lit, MiniSat.neg(target_lit));
        add &= this._me().addClause(MiniSat.neg(left_lit), target_lit);
        return add &= this._me().addClause(MiniSat.neg(right_lit), target_lit);
    }

    default public boolean addBoolAndEqVar(int LEFT, int RIGHT, int TARGET) {
        int left_lit = MiniSat.makeLiteral(LEFT, true);
        int right_lit = MiniSat.makeLiteral(RIGHT, true);
        int target_lit = MiniSat.makeLiteral(TARGET, true);
        boolean add = this._me().addClause(MiniSat.neg(left_lit), MiniSat.neg(right_lit), target_lit);
        add &= this._me().addClause(left_lit, MiniSat.neg(target_lit));
        return add &= this._me().addClause(right_lit, MiniSat.neg(target_lit));
    }

    default public boolean addBoolXorEqVar(int LEFT, int RIGHT, int TARGET) {
        return this.addBoolIsNeqVar(LEFT, RIGHT, TARGET);
    }

    default public boolean addBoolIsEqVar(int LEFT, int RIGHT, int TARGET) {
        int left_lit = MiniSat.makeLiteral(LEFT, true);
        int right_lit = MiniSat.makeLiteral(RIGHT, true);
        int target_lit = MiniSat.makeLiteral(TARGET, true);
        boolean add = this._me().addClause(MiniSat.neg(left_lit), right_lit, MiniSat.neg(target_lit));
        add &= this._me().addClause(left_lit, MiniSat.neg(right_lit), MiniSat.neg(target_lit));
        add &= this._me().addClause(left_lit, right_lit, target_lit);
        return add &= this._me().addClause(MiniSat.neg(left_lit), MiniSat.neg(right_lit), target_lit);
    }

    default public boolean addBoolIsNeqVar(int LEFT, int RIGHT, int TARGET) {
        int left_lit = MiniSat.makeLiteral(LEFT, true);
        int right_lit = MiniSat.makeLiteral(RIGHT, true);
        int target_lit = MiniSat.makeLiteral(TARGET, true);
        boolean add = this._me().addClause(MiniSat.neg(left_lit), right_lit, target_lit);
        add &= this._me().addClause(left_lit, MiniSat.neg(right_lit), target_lit);
        add &= this._me().addClause(left_lit, right_lit, MiniSat.neg(target_lit));
        return add &= this._me().addClause(MiniSat.neg(left_lit), MiniSat.neg(right_lit), MiniSat.neg(target_lit));
    }

    default public boolean addBoolIsLeVar(int LEFT, int RIGHT, int TARGET) {
        int left_lit = MiniSat.makeLiteral(LEFT, true);
        int right_lit = MiniSat.makeLiteral(RIGHT, true);
        int target_lit = MiniSat.makeLiteral(TARGET, true);
        boolean add = this._me().addClause(MiniSat.neg(left_lit), right_lit, MiniSat.neg(target_lit));
        add &= this._me().addClause(left_lit, target_lit);
        return add &= this._me().addClause(MiniSat.neg(right_lit), target_lit);
    }

    default public boolean addBoolIsLtVar(int LEFT, int RIGHT, int TARGET) {
        int left_lit = MiniSat.makeLiteral(LEFT, true);
        int right_lit = MiniSat.makeLiteral(RIGHT, true);
        int target_lit = MiniSat.makeLiteral(TARGET, true);
        boolean add = this._me().addClause(left_lit, right_lit, MiniSat.neg(target_lit));
        add &= this._me().addClause(MiniSat.neg(left_lit), right_lit, MiniSat.neg(target_lit));
        add &= this._me().addClause(left_lit, MiniSat.neg(right_lit), target_lit);
        return add &= this._me().addClause(MiniSat.neg(left_lit), MiniSat.neg(right_lit), MiniSat.neg(target_lit));
    }

    default public boolean addBoolOrArrayEqualTrue(int ... BOOLVARS) {
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            lits.add(MiniSat.makeLiteral(BOOLVARS[i], true));
        }
        return this._me().addClause(lits);
    }

    default public boolean addBoolAndArrayEqualFalse(int ... BOOLVARS) {
        return this.addAtMostNMinusOne(BOOLVARS);
    }

    default public boolean addAtMostOne(int ... BOOLVARS) {
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            lits.add(MiniSat.neg(MiniSat.makeLiteral(BOOLVARS[i], true)));
        }
        boolean add = true;
        for (int i = 0; i < lits.size() - 1; ++i) {
            for (int j = i + 1; j < lits.size(); ++j) {
                add &= this._me().addClause(lits.get(i), lits.get(j));
            }
        }
        return add;
    }

    default public boolean addAtMostNMinusOne(int ... BOOLVARS) {
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            lits.add(MiniSat.makeLiteral(BOOLVARS[i], false));
        }
        return this._me().addClause(lits);
    }

    default public boolean addSumBoolArrayGreaterEqVar(int[] BOOLVARS, int TARGET) {
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length + 1);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            lits.add(MiniSat.makeLiteral(BOOLVARS[i], true));
        }
        lits.add(MiniSat.makeLiteral(TARGET, false));
        return this._me().addClause(lits);
    }

    default public boolean addMaxBoolArrayLessEqVar(int[] BOOLVARS, int TARGET) {
        int tlit = MiniSat.makeLiteral(TARGET, true);
        boolean add = true;
        for (int i = 0; i < BOOLVARS.length; ++i) {
            add &= this._me().addClause(MiniSat.makeLiteral(BOOLVARS[i], false), tlit);
        }
        return true;
    }

    default public boolean addSumBoolArrayLessEqKVar(int[] BOOLVARS, int TARGET) {
        if (BOOLVARS.length == 1) {
            return this.addBoolLe(BOOLVARS[0], TARGET);
        }
        int extra = this._me().newVariable();
        int tlit = MiniSat.makeLiteral(TARGET, true);
        int elit = MiniSat.makeLiteral(extra, true);
        TIntArrayList lits = new TIntArrayList(BOOLVARS.length + 1);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            lits.add(MiniSat.makeLiteral(BOOLVARS[i], true));
        }
        lits.add(MiniSat.neg(elit));
        boolean add = this._me().addClause(lits);
        for (int i = 0; i < BOOLVARS.length; ++i) {
            add &= this._me().addClause(elit, MiniSat.makeLiteral(BOOLVARS[i], false));
        }
        return add &= this._me().addClause(MiniSat.neg(elit), tlit);
    }
}

