## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(renz)
library(knitr)
data(ONPG, package = "renz")

## -----------------------------------------------------------------------------
kable(ONPG)

## -----------------------------------------------------------------------------
attributes(ONPG)

## -----------------------------------------------------------------------------
ONPG[ , 4:7] <- 1000 * ONPG[ , 4:7]

## -----------------------------------------------------------------------------
oldmar <- par()$mar
oldmfrow <- par()$mfrow
par(mfrow = c(2, 2))
par(mar = c(4, 4,1,1))
for (i in 2:5){
  plot(ONPG$ONPG, ONPG[, i],
       ty = 'p', ylab = 'v (uM/min)', xlab = '[ONPG] (mM)')
}
par(mar = oldmar)
par(mfrow = oldmfrow)

## -----------------------------------------------------------------------------
oldmar <- par()$mar
oldmfrow <- par()$mfrow
par(mfrow = c(2, 2))
par(mar = c(4, 4,1,1))
for (i in 6:9){
  plot(ONPG$ONPG, ONPG[, i],
       ty = 'p', ylab = 'v (uM/min)', xlab = '[ONPG] (mM)')
}
par(mar = oldmar)
par(mfrow = oldmfrow)

## -----------------------------------------------------------------------------
ONPG$v2[8] <- NA

## -----------------------------------------------------------------------------
g1 <- lb(ONPG[ , c(1,2)])

## -----------------------------------------------------------------------------
g5 <- lb(ONPG[ , c(1,6)])

## -----------------------------------------------------------------------------
g8 <- lb(ONPG[ , c(1,8)])

## -----------------------------------------------------------------------------
wg1 <- lb(ONPG[ , c(1,2)], weighting = TRUE)

## -----------------------------------------------------------------------------
wg5 <- lb(ONPG[ , c(1,6)], weighting = TRUE)

## -----------------------------------------------------------------------------
g7 <- lb(ONPG[ , c(1,8)], weighting = TRUE)

## ----include=FALSE------------------------------------------------------------
DR <- as.data.frame(matrix(rep(NA, 8 * 5), ncol = 5))
names(DR) <- c('uw_Km', 'uw_Vm', 'R2', 'w_Km', 'w_Vm')
for (i in 1:(ncol(ONPG) - 1)){
  d <- ONPG[, c(1, i+1)]
  t <- lb(d, weighting = TRUE, plot = FALSE)
  DR$uw_Km[i] <- t$Kms
  DR$uw_Vm[i] <- t$Vms
  DR$R2[i] <- t$R2s
  DR$w_Km[i] <- t$fitted_parameters[1]
  DR$w_Vm[i] <- t$fitted_parameters[2]
}

## ----echo=FALSE---------------------------------------------------------------
k <- data.frame(Km = c(DR$uw_Km, DR$w_Km), Vm = c(DR$uw_Vm, DR$w_Vm))
k$weight <- c(rep(FALSE, 8), rep(TRUE, 8))
boxplot(k$Km ~ k$weight, xlab = "Weighted analysis", ylab = "Km (mM)")

## -----------------------------------------------------------------------------
hw7 <- hw(ONPG[ , c(1,8)], unit_v = 'uM/min')

## -----------------------------------------------------------------------------
eh7 <- eh(ONPG[ , c(1,8)], unit_v = 'uM/min')

## -----------------------------------------------------------------------------
ecb7 <- ecb(ONPG[ , c(1,8)], unit_v = "uM/min")
ecb7$Km
ecb7$Vm

