/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.forcefield.mmff;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.forcefield.mmff.MmffAtomTypeMatcher;
import org.openscience.cdk.forcefield.mmff.MmffParamSet;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;

public class Mmff {
    private static final String MMFF_ADJLIST_CACHE = "mmff.adjlist.cache";
    private static final String MMFF_EDGEMAP_CACHE = "mmff.edgemap.cache";
    private static final String MMFF_AROM = "mmff.arom";
    private final MmffAtomTypeMatcher mmffAtomTyper = new MmffAtomTypeMatcher();
    private final MmffParamSet mmffParamSet = MmffParamSet.INSTANCE;

    public boolean assignAtomTypes(IAtomContainer mol) {
        for (IAtom atom : mol.atoms()) {
            if (atom.getImplicitHydrogenCount() != null && atom.getImplicitHydrogenCount() <= 0) continue;
            throw new IllegalArgumentException("Hydrogens must be explicit nodes, each must have a zero (non-null) impl H count.");
        }
        GraphUtil.EdgeToBondMap edgeMap = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)mol);
        int[][] adjList = GraphUtil.toAdjList((IAtomContainer)mol, (GraphUtil.EdgeToBondMap)edgeMap);
        mol.setProperty((Object)MMFF_ADJLIST_CACHE, (Object)adjList);
        mol.setProperty((Object)MMFF_EDGEMAP_CACHE, (Object)edgeMap);
        HashSet<IBond> aromBonds = new HashSet<IBond>();
        Set<IChemObject> oldArom = this.getAromatics(mol);
        for (IChemObject chemObj : oldArom) {
            chemObj.setFlag(32, false);
        }
        String[] atomTypes = this.mmffAtomTyper.symbolicTypes(mol, adjList, edgeMap, aromBonds);
        boolean hasUnkType = false;
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            if (atomTypes[i] == null) {
                mol.getAtom(i).setAtomTypeName("UNK");
                hasUnkType = true;
                continue;
            }
            mol.getAtom(i).setAtomTypeName(atomTypes[i]);
        }
        for (IChemObject chemObj : oldArom) {
            chemObj.setFlag(32, true);
        }
        for (IBond bond : aromBonds) {
            bond.setProperty((Object)MMFF_AROM, (Object)true);
        }
        return !hasUnkType;
    }

    public boolean effectiveCharges(IAtomContainer mol) {
        int[][] adjList = (int[][])mol.getProperty((Object)MMFF_ADJLIST_CACHE);
        GraphUtil.EdgeToBondMap edgeMap = (GraphUtil.EdgeToBondMap)mol.getProperty((Object)MMFF_EDGEMAP_CACHE);
        if (adjList == null || edgeMap == null) {
            throw new IllegalArgumentException("Invoke assignAtomTypes first.");
        }
        this.primaryCharges(mol, adjList, edgeMap);
        this.effectiveCharges(mol, adjList);
        return true;
    }

    public boolean partialCharges(IAtomContainer mol) {
        int[][] adjList = (int[][])mol.getProperty((Object)MMFF_ADJLIST_CACHE);
        GraphUtil.EdgeToBondMap edgeMap = (GraphUtil.EdgeToBondMap)mol.getProperty((Object)MMFF_EDGEMAP_CACHE);
        if (adjList == null || edgeMap == null) {
            throw new IllegalArgumentException("Invoke assignAtomTypes first.");
        }
        this.effectiveCharges(mol);
        for (int v = 0; v < mol.getAtomCount(); ++v) {
            IAtom atom = mol.getAtom(v);
            String symbType = atom.getAtomTypeName();
            int thisType = this.mmffParamSet.intType(symbType);
            if (thisType == 0) continue;
            double pbci = this.mmffParamSet.getPartialBondChargeIncrement(thisType).doubleValue();
            for (int w : adjList[v]) {
                int otherType = this.mmffParamSet.intType(mol.getAtom(w).getAtomTypeName());
                if (otherType == 0) continue;
                IBond bond = edgeMap.get(v, w);
                int bondCls = this.mmffParamSet.getBondCls(thisType, otherType, bond.getOrder().numeric(), bond.getProperty((Object)MMFF_AROM) != null);
                BigDecimal bci = this.mmffParamSet.getBondChargeIncrement(bondCls, thisType, otherType);
                if (bci != null) {
                    atom.setCharge(Double.valueOf(atom.getCharge() - bci.doubleValue()));
                    continue;
                }
                atom.setCharge(Double.valueOf(atom.getCharge() + (pbci - this.mmffParamSet.getPartialBondChargeIncrement(otherType).doubleValue())));
            }
        }
        return true;
    }

    public void clearProps(IAtomContainer mol) {
        mol.removeProperty((Object)MMFF_EDGEMAP_CACHE);
        mol.removeProperty((Object)MMFF_ADJLIST_CACHE);
        for (IBond bond : mol.bonds()) {
            bond.removeProperty((Object)MMFF_AROM);
        }
    }

    void primaryCharges(IAtomContainer mol, int[][] adjList, GraphUtil.EdgeToBondMap edgeMap) {
        for (int v = 0; v < mol.getAtomCount(); ++v) {
            int n;
            IAtom atom = mol.getAtom(v);
            String symbType = atom.getAtomTypeName();
            BigDecimal fc = this.mmffParamSet.getFormalCharge(symbType);
            atom.setCharge(Double.valueOf(0.0));
            if (fc != null) {
                atom.setCharge(Double.valueOf(fc.doubleValue()));
                continue;
            }
            if (symbType.equals("O2S") || symbType.equals("O3S") || symbType.equals("O2P") || symbType.equals("O3P") || symbType.equals("O4P")) {
                if (atom.getCharge() != 0.0) continue;
                int focus = -1;
                for (int w : adjList[v]) {
                    int elem = mol.getAtom(w).getAtomicNumber();
                    if (elem != Elements.Sulfur.number() && elem != Elements.Phosphorus.number()) continue;
                    if (focus >= 0) {
                        focus = -2;
                        break;
                    }
                    focus = w;
                }
                if (focus < 0) continue;
                double qSum = this.fCharge(mol.getAtom(focus));
                int nTerm = 0;
                int[] w = adjList[focus];
                int n2 = w.length;
                for (n = 0; n < n2; ++n) {
                    int w2 = w[n];
                    if (!mol.getAtom(w2).getAtomTypeName().equals(symbType)) continue;
                    qSum += (double)this.fCharge(mol.getAtom(w2));
                    ++nTerm;
                }
                if (nTerm == 0) continue;
                double qSplt = qSum / (double)nTerm;
                for (int w3 : adjList[focus]) {
                    if (!mol.getAtom(w3).getAtomTypeName().equals(symbType)) continue;
                    atom.setCharge(Double.valueOf(qSplt));
                }
                continue;
            }
            if (!symbType.equals("N5M") || atom.getCharge() != 0.0) continue;
            HashSet<IAtom> eqiv = new HashSet<IAtom>();
            HashSet<Integer> visit = new HashSet<Integer>();
            ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
            queue.add(v);
            while (!queue.isEmpty()) {
                int w = (Integer)queue.poll();
                visit.add(w);
                if (mol.getAtom(w).getAtomTypeName().equals("N5M")) {
                    eqiv.add(mol.getAtom(w));
                }
                int[] nArray = adjList[w];
                int n3 = nArray.length;
                for (n = 0; n < n3; ++n) {
                    int u = nArray[n];
                    IBond bond = edgeMap.get(w, u);
                    if (bond.getProperty((Object)MMFF_AROM) == null || visit.contains(u)) continue;
                    queue.add(u);
                }
            }
            double q = 0.0;
            for (IAtom eqivAtom : eqiv) {
                q += (double)this.fCharge(eqivAtom);
            }
            q /= (double)eqiv.size();
            for (IAtom eqivAtom : eqiv) {
                eqivAtom.setCharge(Double.valueOf(q));
            }
        }
    }

    void effectiveCharges(IAtomContainer mol, int[][] adjList) {
        int v;
        double[] tmp = new double[mol.getAtomCount()];
        for (v = 0; v < tmp.length; ++v) {
            IAtom atom = mol.getAtom(v);
            int intType = this.mmffParamSet.intType(atom.getAtomTypeName());
            if (intType == 0) continue;
            int crd = this.mmffParamSet.getCrd(intType);
            BigDecimal fcAdj = this.mmffParamSet.getFormalChargeAdjustment(intType);
            double adjust = fcAdj.doubleValue();
            tmp[v] = atom.getCharge();
            if (adjust == 0.0) {
                for (int w : adjList[v]) {
                    if (!(mol.getAtom(w).getCharge() < 0.0)) continue;
                    int n = v;
                    tmp[n] = tmp[n] + mol.getAtom(w).getCharge() / (2.0 * (double)adjList[w].length);
                }
            }
            if (atom.getAtomTypeName().equals("NM")) {
                for (int w : adjList[v]) {
                    if (!(mol.getAtom(w).getCharge() > 0.0)) continue;
                    int n = v;
                    tmp[n] = tmp[n] - mol.getAtom(w).getCharge() / 2.0;
                }
            }
            if (adjust == 0.0) continue;
            double q = 0.0;
            for (int w : adjList[v]) {
                q += mol.getAtom(w).getCharge().doubleValue();
            }
            tmp[v] = (1.0 - (double)crd * adjust) * tmp[v] + adjust * q;
        }
        for (v = 0; v < tmp.length; ++v) {
            mol.getAtom(v).setCharge(Double.valueOf(tmp[v]));
        }
    }

    private Set<IChemObject> getAromatics(IAtomContainer mol) {
        HashSet<IChemObject> oldArom = new HashSet<IChemObject>();
        for (IAtom atom : mol.atoms()) {
            if (!atom.getFlag(32)) continue;
            oldArom.add((IChemObject)atom);
        }
        for (IBond bond : mol.bonds()) {
            if (!bond.getFlag(32)) continue;
            oldArom.add((IChemObject)bond);
        }
        return oldArom;
    }

    int fCharge(IAtom atom) {
        if (atom.getFormalCharge() == null) {
            return 0;
        }
        return atom.getFormalCharge();
    }
}

