/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.openscience.cdk.interfaces.IIsotope;

public class MolecularFormulaRange
implements Cloneable {
    private final Map<IIsotope, Integer> isotopesMax = new HashMap<IIsotope, Integer>();
    private final Map<IIsotope, Integer> isotopesMin = new HashMap<IIsotope, Integer>();

    public void addIsotope(IIsotope isotope, int countMin, int countMax) {
        if (isotope == null) {
            throw new IllegalArgumentException("Isotope must not be null");
        }
        boolean flag = false;
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            this.isotopesMax.put(thisIsotope, countMax);
            this.isotopesMin.put(thisIsotope, countMin);
            flag = true;
            break;
        }
        if (!flag) {
            this.isotopesMax.put(isotope, countMax);
            this.isotopesMin.put(isotope, countMin);
        }
    }

    public boolean contains(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            return true;
        }
        return false;
    }

    public int getIsotopeCountMax(IIsotope isotope) {
        return !this.contains(isotope) ? -1 : this.isotopesMax.get(this.getIsotope(isotope));
    }

    public int getIsotopeCountMin(IIsotope isotope) {
        return !this.contains(isotope) ? -1 : this.isotopesMin.get(this.getIsotope(isotope));
    }

    public int getIsotopeCount() {
        return this.isotopesMax.size();
    }

    private IIsotope getIsotope(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(isotope, thisIsotope)) continue;
            return thisIsotope;
        }
        return null;
    }

    public Iterable<IIsotope> isotopes() {
        return new Iterable<IIsotope>(){

            @Override
            public Iterator<IIsotope> iterator() {
                return MolecularFormulaRange.this.isotopesMax.keySet().iterator();
            }
        };
    }

    public void removeAllIsotopes() {
        this.isotopesMax.clear();
        this.isotopesMin.clear();
    }

    public void removeIsotope(IIsotope isotope) {
        this.isotopesMax.remove(this.getIsotope(isotope));
        this.isotopesMin.remove(this.getIsotope(isotope));
    }

    public Object clone() throws CloneNotSupportedException {
        MolecularFormulaRange clone = new MolecularFormulaRange();
        for (IIsotope isotope : this.isotopes()) {
            clone.addIsotope((IIsotope)isotope.clone(), this.getIsotopeCountMin(isotope), this.getIsotopeCountMax(isotope));
        }
        return clone;
    }

    private boolean isTheSame(IIsotope isotopeOne, IIsotope isotopeTwo) {
        if (!isotopeOne.getAtomicNumber().equals(isotopeTwo.getAtomicNumber())) {
            return false;
        }
        if (!Objects.equals(isotopeOne.getNaturalAbundance(), isotopeTwo.getNaturalAbundance())) {
            return false;
        }
        return Objects.equals(isotopeOne.getExactMass(), isotopeTwo.getExactMass());
    }
}

