/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.file_chooser;

import com.qarks.util.ui.swing.file_chooser.DefaultFileView;
import java.io.File;
import java.util.Hashtable;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class FileSystemParserUtility {
    private Hashtable mFileTable = new Hashtable(10);
    private Hashtable mParentTable = new Hashtable(10);
    private Hashtable mDescriptionTable = new Hashtable(10);
    private static final int INIT_SIZE = 10;
    private static final FileSystemParserUtility sInstance = new FileSystemParserUtility();
    private FileView mFileView = null;
    private FileSystemView mFileSystemView = FileSystemView.getFileSystemView();

    protected FileSystemParserUtility() {
        this.mFileView = new DefaultFileView();
    }

    public static FileSystemParserUtility getInstance() {
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] listFiles(File file, boolean bl) {
        String string = this.getFileUniqueName(file);
        File[] fileArray = new File[]{};
        boolean bl2 = false;
        if (!bl) {
            Hashtable hashtable = this.mFileTable;
            synchronized (hashtable) {
                if (this.mFileTable.containsKey(string)) {
                    fileArray = (File[])this.mFileTable.get(string);
                    bl2 = true;
                }
            }
        }
        if (!bl2 && file != null) {
            boolean bl3 = false;
            try {
                bl3 = file != null && this.mFileSystemView.isTraversable(file) != false;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                boolean bl4 = bl3 = file != null && file.isDirectory();
            }
            if (bl3 && (fileArray = file.listFiles()) != null && !this.isSystemDirectory(file)) {
                fileArray = this.alphabeticSortFiles(fileArray);
                Hashtable hashtable = this.mFileTable;
                synchronized (hashtable) {
                    this.mFileTable.put(string, fileArray);
                }
            }
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFile(File file) {
        Hashtable hashtable = this.mFileTable;
        synchronized (hashtable) {
            String string = this.getFileUniqueName(file);
            if (this.mFileTable.containsKey(string)) {
                this.mFileTable.remove(string);
            }
        }
    }

    public void lookupTree(File file, boolean bl) {
        final File file2 = file;
        final boolean bl2 = bl;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File file = file2;
                File file22 = null;
                while (file != null) {
                    FileSystemParserUtility.this.listFiles(file, bl2);
                    file22 = FileSystemParserUtility.this.mFileSystemView.getParentDirectory(file);
                    String string = FileSystemParserUtility.this.getFileUniqueName(file);
                    if (file22 != null) {
                        Hashtable hashtable = FileSystemParserUtility.this.mParentTable;
                        synchronized (hashtable) {
                            FileSystemParserUtility.this.mParentTable.put(string, file22);
                        }
                    }
                    file = file22;
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getParentFile(File file, boolean bl) {
        File file2 = null;
        if (!this.mFileSystemView.isRoot(file)) {
            Hashtable hashtable = this.mParentTable;
            synchronized (hashtable) {
                String string = this.getFileUniqueName(file);
                if (!bl && this.mParentTable.containsKey(string)) {
                    file2 = (File)this.mParentTable.get(string);
                } else {
                    file2 = this.mFileSystemView.getParentDirectory(file);
                    if (file2 != null) {
                        this.mParentTable.put(string, file2);
                    }
                }
            }
        }
        return file2;
    }

    private String getFileUniqueName(File file) {
        return file.getAbsolutePath() + "##" + this.mFileView.getName(file);
    }

    public String getTypeDescription(File file) {
        String string;
        int n;
        String string2 = "";
        if (file != null && file.exists() && (n = (string = file.getName()).lastIndexOf(".")) > -1) {
            String string3 = string.substring(n);
            Object v = this.mDescriptionTable.get(string3);
            if (v != null) {
                string2 = (String)v;
            } else {
                string2 = this.mFileView.getTypeDescription(file);
                this.mDescriptionTable.put(string3, string2);
            }
        }
        return string2;
    }

    private boolean isSystemDirectory(File file) {
        boolean bl = false;
        try {
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            bl = fileSystemView.isRoot(file) || this.isComputerNode(file) || fileSystemView.isDrive(file) || fileSystemView.isFloppyDrive(file) || fileSystemView.isRoot(file);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return bl;
    }

    private boolean isComputerNode(File file) {
        String string;
        boolean bl = false;
        if (file != null && (string = file.getPath()).startsWith("::") && string.indexOf("\\") == -1) {
            bl = true;
        }
        return bl;
    }

    private File[] alphabeticSortFiles(File[] fileArray) {
        return this.alphabeticSortFiles(fileArray, 0, fileArray.length - 1);
    }

    private File[] alphabeticSortFiles(File[] fileArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            String string = this.mFileView.getName(fileArray[(n + n2) / 2]);
            while (n3 <= n4) {
                while (n3 < n2 && this.mFileView.getName(fileArray[n3]).compareToIgnoreCase(string) < 0) {
                    ++n3;
                }
                while (n4 > n && this.mFileView.getName(fileArray[n4]).compareToIgnoreCase(string) > 0) {
                    --n4;
                }
                if (n3 > n4) continue;
                File file = fileArray[n3];
                fileArray[n3] = fileArray[n4];
                fileArray[n4] = file;
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.alphabeticSortFiles(fileArray, n, n4);
            }
            if (n3 < n2) {
                this.alphabeticSortFiles(fileArray, n3, n2);
            }
        }
        return fileArray;
    }
}

