/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.global.matching;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.constraints.global.matching.AbstractBipartiteGraph;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class AbstractBipartiteMatching
extends AbstractBipartiteGraph {
    protected IStateIntVector refInverseMatch;

    public AbstractBipartiteMatching(IEnvironment environment, IntDomainVar[] vars, int nbLeft, int nbRight) {
        super(environment, vars, nbLeft, nbRight);
        this.refInverseMatch = environment.makeIntVector(this.nbRightVertices, -1);
    }

    @Override
    protected void init() {
        super.init();
        for (int i = 0; i < this.nbRightVertices; ++i) {
            this.refInverseMatch.set(i, -1);
        }
    }

    public int inverseMatch(int j) {
        return this.refInverseMatch.get(j);
    }

    @Override
    public void increaseMatchingSize(int j) {
        this.matchingSize.set(this.matchingSize.get() + 1);
    }

    @Override
    public void decreaseMatchingSize(int j) {
        this.matchingSize.set(this.matchingSize.get() - 1);
    }

    @Override
    public void deleteMatch(int i, int j) {
        if (j == this.refMatch.get(i)) {
            this.refMatch.set(i, -1);
            this.refInverseMatch.set(j, -1);
            this.decreaseMatchingSize(j);
        }
    }

    @Override
    public void putRefMatch(int i, int j) {
        this.refMatch.set(i, j);
        this.refInverseMatch.set(j, i);
    }

    @Override
    public void setMatch(int i, int j) {
        int j0 = this.refMatch.get(i);
        int i0 = this.refInverseMatch.get(j);
        if (j0 != j) {
            if (j0 >= 0) {
                this.refInverseMatch.set(j0, -1);
                this.decreaseMatchingSize(j0);
            }
            if (i0 >= 0) {
                this.refMatch.set(i0, -1);
                this.decreaseMatchingSize(j);
            }
            this.refMatch.set(i, j);
            this.refInverseMatch.set(j, i);
            this.increaseMatchingSize(j);
        }
    }

    @Override
    public boolean mayDiminishFlowFromSource(int j) {
        return this.refInverseMatch.get(j) != -1;
    }

    @Override
    public boolean mayGrowFlowFromSource(int j) {
        return this.refInverseMatch.get(j) == -1;
    }

    @Override
    public boolean mustGrowFlowFromSource(int j) {
        return false;
    }
}

