/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.matching;

import choco.cp.solver.constraints.global.matching.GlobalCardinality;
import choco.kernel.memory.IEnvironment;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class GlobalCardinalityVar
extends GlobalCardinality {
    public GlobalCardinalityVar(IntDomainVar[] values, IntDomainVar[] occurences, IEnvironment environment) {
        this(values, 1, occurences.length, occurences, environment);
    }

    public GlobalCardinalityVar(IntDomainVar[] values, int minValue, int maxValue, IntDomainVar[] occurences, IEnvironment environment) {
        super(values, minValue, maxValue, new int[occurences.length], new int[occurences.length], environment);
        int nbVarsTotal = values.length + occurences.length;
        this.vars = new IntDomainVar[nbVarsTotal];
        System.arraycopy(values, 0, this.vars, 0, values.length);
        System.arraycopy(occurences, 0, this.vars, values.length, occurences.length);
        this.cIndices = new int[nbVarsTotal];
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx < this.nbLeftVertices) {
            super.awakeOnInf(idx);
        } else {
            this.checkSumInfs();
            this.deleteSupport();
            this.constAwake(false);
        }
    }

    private void checkSumInfs() throws ContradictionException {
        int sum = 0;
        for (int j = 0; j < this.nbRightVertices; ++j) {
            sum += ((IntDomainVar[])this.vars)[j + this.nbLeftVertices].getInf();
        }
        if (sum > this.nbLeftVertices) {
            this.fail();
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx < this.nbLeftVertices) {
            super.awakeOnRem(idx, x);
        } else {
            this.deleteSupport();
            this.constAwake(false);
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx < this.nbLeftVertices) {
            super.awakeOnSup(idx);
        } else {
            this.deleteSupport();
            this.constAwake(false);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx < this.nbLeftVertices) {
            super.awakeOnInst(idx);
        } else {
            this.checkSumInfs();
            this.deleteSupport();
            this.constAwake(false);
        }
    }

    @Override
    public void awake() throws ContradictionException {
        super.awake();
    }

    public void deleteSupport() {
        for (int i = 0; i < this.nbLeftVertices; ++i) {
            this.refMatch.set(i, -1);
        }
        for (int j = 0; j < this.nbRightVertices; ++j) {
            this.flow.set(j, 0);
        }
        this.matchingSize.set(0);
    }

    @Override
    protected int getMinFlow(int j) {
        return ((IntDomainVar[])this.vars)[this.nbLeftVertices + j].getInf();
    }

    @Override
    protected int getMaxFlow(int j) {
        return ((IntDomainVar[])this.vars)[this.nbLeftVertices + j].getSup();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int i;
        int[] occurrences = new int[this.maxValue - this.minValue + 1];
        int nbvar = tuple.length - occurrences.length;
        for (i = 0; i < nbvar; ++i) {
            int n = tuple[i] - this.minValue;
            occurrences[n] = occurrences[n] + 1;
        }
        for (i = 0; i < occurrences.length; ++i) {
            int occurrence = occurrences[i];
            if (tuple[i + nbvar] == occurrence) continue;
            return false;
        }
        return true;
    }
}

