/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.util;

import choco.Choco;
import choco.cp.solver.constraints.global.geost.geometricPrim.Shape;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.model.variables.geost.GeostObject;
import choco.kernel.model.variables.geost.ShiftedBox;
import choco.kernel.model.variables.integer.IntegerVariable;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InputParser {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    List<GeostObject> obj;
    List<Shape> sh;
    List<ShiftedBox> sb;
    String path;
    int dim;
    GeostProblem gp;

    public InputParser() {
    }

    public InputParser(String path, int dim) {
        this.path = path;
        this.dim = dim;
        this.obj = new ArrayList<GeostObject>();
        this.sh = new ArrayList<Shape>();
        this.sb = new ArrayList<ShiftedBox>();
    }

    public InputParser(GeostProblem gp, int dim) {
        this.dim = dim;
        this.gp = gp;
        this.obj = new ArrayList<GeostObject>();
        this.sh = new ArrayList<Shape>();
        this.sb = new ArrayList<ShiftedBox>();
    }

    public List<GeostObject> getObjects() {
        return this.obj;
    }

    public List<Shape> getShapes() {
        return this.sh;
    }

    public List<ShiftedBox> getShiftedBoxes() {
        return this.sb;
    }

    public boolean parse() throws IOException {
        if (this.path != null) {
            return this.parseFile();
        }
        if (this.gp != null) {
            return this.parseGP();
        }
        return false;
    }

    public boolean parseFile() throws IOException {
        BufferedReader bin = null;
        try {
            bin = new BufferedReader(new FileReader(this.path));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to open data file: {0}\n{1}", new Object[]{this.path, e});
            e.printStackTrace();
            return false;
        }
        String str = "";
        String temp = "";
        String mode = "";
        while ((str = bin.readLine()) != null) {
            if (str.equals("") || str.startsWith("#")) continue;
            if (str.equals("Objects") || str.equals("Shapes") || str.equals("ShiftedBoxes")) {
                mode = str;
                str = bin.readLine();
            }
            StringTokenizer st = new StringTokenizer(str, " ");
            int tokenNb = 0;
            int indice = 0;
            if (mode.equals("Objects")) {
                int id = 0;
                IntegerVariable shape = null;
                IntegerVariable[] coord = new IntegerVariable[this.dim];
                IntegerVariable start = null;
                IntegerVariable duration = null;
                IntegerVariable end = null;
                while (st.hasMoreTokens()) {
                    int j;
                    int upperBound;
                    int lowerBound;
                    temp = st.nextToken();
                    switch (++tokenNb) {
                        case 1: {
                            id = Integer.valueOf(temp);
                            break;
                        }
                        case 2: {
                            String temp2 = st.nextToken();
                            ++tokenNb;
                            shape = Choco.makeIntVar("sid_" + indice, Integer.valueOf(temp), Integer.valueOf(temp2), new String[0]);
                        }
                    }
                    if (tokenNb > 3 && tokenNb <= 3 + 2 * this.dim) {
                        for (int i = 0; i < this.dim; ++i) {
                            lowerBound = -1;
                            upperBound = -1;
                            for (j = 0; j < 2; ++j) {
                                if (j == 0) {
                                    lowerBound = Integer.valueOf(temp);
                                }
                                if (j == 1) {
                                    upperBound = Integer.valueOf(temp);
                                }
                                if (!st.hasMoreTokens()) continue;
                                temp = st.nextToken();
                                ++tokenNb;
                            }
                            coord[i] = Choco.makeIntVar("x_" + indice + "_" + i, lowerBound, upperBound, "cp:bound");
                        }
                        continue;
                    }
                    if (tokenNb <= 3 + 2 * this.dim) continue;
                    for (int i = 0; i < 3; ++i) {
                        lowerBound = -1;
                        upperBound = -1;
                        for (j = 0; j < 2; ++j) {
                            if (j == 0) {
                                lowerBound = Integer.valueOf(temp);
                            }
                            if (j == 1) {
                                upperBound = Integer.valueOf(temp);
                            }
                            if (!st.hasMoreTokens()) continue;
                            temp = st.nextToken();
                            ++tokenNb;
                        }
                        if (i == 0) {
                            start = Choco.makeIntVar("start_" + indice, lowerBound, upperBound, new String[0]);
                            continue;
                        }
                        if (i == 1) {
                            duration = Choco.makeIntVar("duration_" + indice, lowerBound, upperBound, new String[0]);
                            continue;
                        }
                        if (i != 2) continue;
                        end = Choco.makeIntVar("end_" + indice++, lowerBound, upperBound, new String[0]);
                    }
                }
                GeostObject o = new GeostObject(this.dim, id, shape, coord, start, duration, end);
                this.obj.add(o);
            }
            if (mode.equals("Shapes")) {
                Shape s = new Shape();
                temp = st.nextToken();
                s.setShapeId(Integer.valueOf(temp));
                this.sh.add(s);
            }
            if (!mode.equals("ShiftedBoxes")) continue;
            ShiftedBox s = new ShiftedBox();
            while (st.hasMoreTokens()) {
                temp = st.nextToken();
                if (++tokenNb == 1) {
                    s.setShapeId(Integer.valueOf(temp));
                }
                if (tokenNb > 1 && tokenNb <= this.dim + 1) {
                    int[] off = new int[this.dim];
                    for (int i = 0; i < this.dim; ++i) {
                        off[i] = Integer.valueOf(temp);
                        if (i == this.dim - 1) continue;
                        temp = st.nextToken();
                        ++tokenNb;
                    }
                    s.setOffset(off);
                }
                if (tokenNb <= 1 || tokenNb <= this.dim + 1) continue;
                int[] size = new int[this.dim];
                for (int i = 0; i < this.dim; ++i) {
                    size[i] = Integer.valueOf(temp);
                    if (i == this.dim - 1) continue;
                    temp = st.nextToken();
                    ++tokenNb;
                }
                s.setSize(size);
            }
            this.sb.add(s);
        }
        for (int i = 0; i < this.sb.size(); ++i) {
            int index = -1;
            for (int j = 0; j < this.sh.size(); ++j) {
                if (this.sh.get(j).getShapeId() != this.sb.get(i).getShapeId()) continue;
                index = j;
                break;
            }
            if (index == -1) continue;
            this.sh.get(index).addShiftedBox(this.sb.get(i));
        }
        return true;
    }

    public boolean parseGP() {
        int i;
        for (i = 0; i < this.gp.objects.length; ++i) {
            int j = 0;
            int id = this.gp.objects[i][j++];
            IntegerVariable shape = Choco.makeIntVar("sid_" + i, this.gp.objects[i][j++], this.gp.objects[i][j++], new String[0]);
            IntegerVariable[] coord = new IntegerVariable[this.dim];
            for (int k = 0; k < this.dim; ++k) {
                coord[k] = Choco.makeIntVar("x_" + i + "_" + k, this.gp.objects[i][j++], this.gp.objects[i][j++], "cp:bound");
            }
            IntegerVariable start = Choco.makeIntVar("start_" + i, this.gp.objects[i][j++], this.gp.objects[i][j++], new String[0]);
            IntegerVariable duration = Choco.makeIntVar("duration_" + i, this.gp.objects[i][j++], this.gp.objects[i][j++], new String[0]);
            IntegerVariable end = Choco.makeIntVar("end_" + i, this.gp.objects[i][j++], this.gp.objects[i][j], new String[0]);
            GeostObject o = new GeostObject(this.dim, id, shape, coord, start, duration, end);
            this.obj.add(o);
        }
        for (i = 0; i < this.gp.shapes.length; ++i) {
            Shape s = new Shape();
            s.setShapeId(this.gp.shapes[i]);
            this.sh.add(s);
        }
        for (i = 0; i < this.gp.shiftedBoxes.length; ++i) {
            int j = 0;
            ShiftedBox s = new ShiftedBox();
            s.setShapeId(this.gp.shiftedBoxes[i][j++]);
            int[] off = new int[this.dim];
            for (int k = 0; k < this.dim; ++k) {
                off[k] = this.gp.shiftedBoxes[i][j++];
            }
            s.setOffset(off);
            int[] size = new int[this.dim];
            for (int k = 0; k < this.dim; ++k) {
                size[k] = this.gp.shiftedBoxes[i][j++];
            }
            s.setSize(size);
            this.sb.add(s);
        }
        for (i = 0; i < this.sb.size(); ++i) {
            int index = -1;
            for (int j = 0; j < this.sh.size(); ++j) {
                if (this.sh.get(j).getShapeId() != this.sb.get(i).getShapeId()) continue;
                index = j;
                break;
            }
            if (index == -1) continue;
            this.sh.get(index).addShiftedBox(this.sb.get(i));
        }
        return true;
    }

    public static class GeostProblem {
        public int[][] objects;
        public int[] shapes;
        public int[][] shiftedBoxes;

        public GeostProblem(int[][] objects, int[] shapes, int[][] shiftedBoxes) {
            this.objects = objects;
            this.shapes = shapes;
            this.shiftedBoxes = shiftedBoxes;
        }
    }
}

