/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector;

import choco.Choco;
import choco.cp.common.util.preprocessor.DetectorFactory;
import choco.cp.common.util.preprocessor.ExpressionTools;
import choco.cp.common.util.preprocessor.detector.AbstractGraphBasedDetector;
import choco.cp.model.CPModel;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.cp.solver.preprocessor.PreProcessCPSolver;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.MetaConstraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;

public class DisjunctionsSolverDetector
extends AbstractGraphBasedDetector {
    private final PreProcessCPSolver ppsolver;

    public DisjunctionsSolverDetector(CPModel model, PreProcessCPSolver solver) {
        super(model);
        this.ppsolver = solver;
    }

    private static int[] getVarIndexes(IntegerVariable[] vs) {
        int[] idxs = new int[vs.length];
        for (int i = 0; i < idxs.length; ++i) {
            idxs[i] = vs[i].getHook();
        }
        return idxs;
    }

    @Override
    public void apply() {
        int currentHook = DetectorFactory.maxHookOnMultipleVariables(this.model);
        int[] durations = this.addAllDisjunctiveEdges(this.ppsolver);
        if (durations != null) {
            BitSet[] precedenceAlreadyAdded = new BitSet[this.model.getNbIntVars()];
            int nbIvar = this.model.getNbIntVars();
            for (int i = 0; i < nbIvar; ++i) {
                precedenceAlreadyAdded[i] = new BitSet(nbIvar);
            }
            AbstractGraphBasedDetector.CliqueIterator it = this.cliqueIterator();
            while (it.hasNext()) {
                IntegerVariable[] cl = it.next();
                int[] idxs = DisjunctionsSolverDetector.getVarIndexes(cl);
                int[] dur = new int[cl.length];
                Variable[] tasks = new TaskVariable[cl.length];
                for (int i = 0; i < cl.length; ++i) {
                    dur[i] = durations[idxs[i]];
                    tasks[i] = Choco.makeTaskVar("", cl[i], (IntegerVariable)Choco.constant(dur[i]), new String[0]);
                }
                for (int j = 0; j < cl.length; ++j) {
                    for (int k = j + 1; k < cl.length; ++k) {
                        if (precedenceAlreadyAdded[idxs[j]].get(idxs[k])) continue;
                        IntegerVariable b = Choco.makeIntVar(String.format("%d", dur[j] + dur[k]), 0, 1, new String[0]);
                        this.add(Choco.precedenceDisjoint(cl[j], dur[j], cl[k], dur[k], b));
                        precedenceAlreadyAdded[idxs[j]].set(idxs[k]);
                        precedenceAlreadyAdded[idxs[k]].set(idxs[j]);
                    }
                }
                this.add(Choco.disjunctive((TaskVariable[])tasks, new String[0]));
                DetectorFactory.associateIndexes(currentHook, tasks);
                currentHook += tasks.length;
                it.remove();
            }
        }
    }

    public int[] addAllDisjunctiveEdges(PreProcessCPSolver ppcs) {
        Iterator<Constraint> it = this.model.getConstraintIterator();
        int[] durations = new int[this.model.getNbIntVars()];
        Arrays.fill(durations, -1);
        boolean b = false;
        while (it.hasNext()) {
            ExpressionSConstraint es;
            ExpressionTools.SimplePrecedence sp;
            Constraint ic = it.next();
            if (!(ic instanceof MetaConstraint) || (sp = ExpressionTools.getPrecedenceConstraint(es = new ExpressionSConstraint(ppcs.getMod2Sol().buildNode(ic)))) == null) continue;
            b = true;
            this.addEdge(sp.v1, sp.v2, ic);
            int idx1 = sp.v1.getHook();
            int idx2 = sp.v2.getHook();
            if (durations[idx1] == -1) {
                durations[idx1] = sp.d1;
            } else if (durations[idx1] != sp.d1) {
                return null;
            }
            if (durations[idx2] == -1) {
                durations[idx2] = sp.d2;
                continue;
            }
            if (durations[idx2] == sp.d2) continue;
            return null;
        }
        if (b) {
            return durations;
        }
        return null;
    }
}

