/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.DenseVector;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.SparseVector;
import cc.mallet.util.PropertyList;
import com.google.errorprone.annotations.Var;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class AugmentableFeatureVector
extends FeatureVector
implements Serializable {
    int size;
    int maxSortedIndex;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public AugmentableFeatureVector(Alphabet dict, int[] indices, double[] values, int capacity, int size, boolean copy, boolean checkIndicesSorted, boolean removeDuplicates) {
        super(dict, indices, values, capacity, size, copy, checkIndicesSorted, removeDuplicates);
        if (!checkIndicesSorted) {
            if (!removeDuplicates) {
                this.size = size;
            }
            this.maxSortedIndex = this.size - 1;
        }
    }

    public AugmentableFeatureVector(Alphabet dict, int[] indices, double[] values, int capacity, boolean copy, boolean checkIndicesSorted) {
        this(dict, indices, values, capacity, indices.length, copy, checkIndicesSorted, true);
    }

    public AugmentableFeatureVector(Alphabet dict, int[] indices, double[] values, int capacity, boolean copy) {
        this(dict, indices, values, capacity, indices.length, copy, true, true);
    }

    public AugmentableFeatureVector(Alphabet dict, int[] indices, double[] values, int capacity) {
        this(dict, indices, values, capacity, indices.length, true, true, true);
    }

    public AugmentableFeatureVector(Alphabet dict, double[] values, int capacity) {
        this(dict, null, values, capacity, values.length, true, true, true);
    }

    public AugmentableFeatureVector(Alphabet dict, double[] values) {
        this(dict, null, values, values.length, values.length, true, true, true);
    }

    public AugmentableFeatureVector(Alphabet dict, int capacity, boolean binary) {
        this(dict, new int[capacity], binary ? null : new double[capacity], capacity, 0, false, false, false);
    }

    public AugmentableFeatureVector(Alphabet dict, boolean binary) {
        this(dict, 4, binary);
    }

    public AugmentableFeatureVector(Alphabet dict) {
        this(dict, false);
    }

    public AugmentableFeatureVector(FeatureVector fv) {
        this(fv.dictionary, fv.indices, fv.values, fv.indices == null ? fv.values.length : fv.indices.length, fv.indices == null ? fv.values.length : fv.indices.length, true, false, false);
    }

    public AugmentableFeatureVector(FeatureSequence fs, boolean binary) {
        this(fs.getAlphabet(), binary);
        for (int i = fs.size() - 1; i >= 0; --i) {
            this.add(fs.getIndexAtPosition(i), 1.0);
        }
    }

    public AugmentableFeatureVector(Alphabet dict, PropertyList pl, boolean binary, boolean growAlphabet) {
        this(dict, binary);
        if (pl == null) {
            return;
        }
        PropertyList.Iterator iter = pl.numericIterator();
        while (iter.hasNext()) {
            iter.nextProperty();
            int index = dict.lookupIndex(iter.getKey(), growAlphabet);
            if (index < 0) continue;
            this.add(index, iter.getNumericValue());
        }
    }

    public AugmentableFeatureVector(Alphabet dict, PropertyList pl, boolean binary) {
        this(dict, pl, binary, true);
    }

    public void add(FeatureVector fv) {
        for (int loc = 0; loc < fv.numLocations(); ++loc) {
            int index = fv.indexAtLocation(loc);
            double value = fv.valueAtLocation(loc);
            if (this.location(index) != -1) continue;
            this.add(index, value);
        }
    }

    public void add(FeatureVector fv, String prefix) {
        Alphabet otherDict = fv.getAlphabet();
        for (int loc = 0; loc < fv.numLocations(); ++loc) {
            int idx = fv.indexAtLocation(loc);
            String otherName = (String)otherDict.lookupObject(idx);
            this.add(prefix + otherName, 1.0);
        }
    }

    public void add(FeatureVector fv, String prefix, boolean binary) {
        if (binary) {
            this.add(fv, prefix);
        } else {
            Alphabet otherDict = fv.getAlphabet();
            for (int loc = 0; loc < fv.numLocations(); ++loc) {
                int idx = fv.indexAtLocation(loc);
                double val = fv.valueAtLocation(loc);
                String otherName = (String)otherDict.lookupObject(idx);
                this.add(prefix + otherName, val);
            }
        }
    }

    public void add(int index, double value) {
        if (this.values == null && value != 1.0) {
            throw new IllegalArgumentException("Trying to add non-1.0 value (" + this.dictionary.lookupObject(index) + "=" + value + ") to binary vector");
        }
        assert (index >= 0);
        if (this.indices == null) {
            if (index >= this.values.length) {
                int newLength = index + 10;
                double[] newValues = new double[newLength];
                System.arraycopy(this.values, 0, newValues, 0, this.values.length);
                this.values = newValues;
                this.values[index] = value;
                assert (this.size <= index);
            } else {
                int n = index;
                this.values[n] = this.values[n] + value;
            }
            if (this.size <= index) {
                this.size = index + 1;
            }
        } else {
            if (this.size == this.indices.length) {
                int newLength = this.indices.length == 0 ? 4 : (this.indices.length < 4 ? this.indices.length * 2 : (this.indices.length < 100 ? this.indices.length * 3 / 2 : this.indices.length + 150));
                if (this.values != null) {
                    double[] newValues = new double[newLength];
                    System.arraycopy(this.values, 0, newValues, 0, this.values.length);
                    this.values = newValues;
                }
                int[] newIndices = new int[newLength];
                System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
                this.indices = newIndices;
            }
            this.indices[this.size] = index;
            if (this.values != null) {
                this.values[this.size] = value;
            }
            ++this.size;
        }
    }

    public void add(Object key, double value) {
        int index = this.dictionary.lookupIndex(key);
        assert (index != -1);
        this.add(index, value);
    }

    public void add(int index) {
        if (this.values != null) {
            throw new IllegalArgumentException("Trying to add binary feature to real-valued vector");
        }
        assert (index >= 0);
        this.add(index, 1.0);
    }

    @Override
    public final int numLocations() {
        if (this.indices == null) {
            return this.size;
        }
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        return this.size;
    }

    @Override
    public final int location(int index) {
        if (this.indices == null) {
            return index;
        }
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.indices[i] == index) {
                return i;
            }
            if (this.indices[i] <= index) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public final double valueAtLocation(int location) {
        if (this.indices == null) {
            return this.values[location];
        }
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        return super.valueAtLocation(location);
    }

    @Override
    public final int indexAtLocation(int location) {
        if (this.indices == null) {
            return location;
        }
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        assert (location < this.size);
        return super.indexAtLocation(location);
    }

    @Override
    public final double value(int index) {
        int loc;
        if (this.indices == null) {
            return this.values[index];
        }
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        if ((loc = this.location(index)) >= 0) {
            if (this.values == null) {
                return 1.0;
            }
            return this.values[loc];
        }
        return 0.0;
    }

    @Override
    public final void addTo(double[] accumulator, double scale) {
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        if (this.indices == null) {
            for (int i = 0; i < this.size; ++i) {
                int n = i;
                accumulator[n] = accumulator[n] + this.values[i] * scale;
            }
        } else if (this.values == null) {
            for (int i = 0; i < this.size; ++i) {
                int n = this.indices[i];
                accumulator[n] = accumulator[n] + scale;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                int n = this.indices[i];
                accumulator[n] = accumulator[n] + this.values[i] * scale;
            }
        }
    }

    @Override
    public final void addTo(double[] accumulator) {
        this.addTo(accumulator, 1.0);
    }

    @Override
    public final void setValue(int index, double value) {
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        assert (this.values != null);
        if (this.indices == null) {
            assert (index < this.size);
            this.values[index] = value;
        } else {
            this.values[this.location((int)index)] = value;
        }
    }

    @Override
    public final void setValueAtLocation(int location, double value) {
        assert (location < this.size);
        this.values[location] = value;
    }

    @Override
    public ConstantMatrix cloneMatrix() {
        return new AugmentableFeatureVector(this.dictionary, this.indices, this.values, this.indices.length, this.size, true, false, false);
    }

    @Override
    public ConstantMatrix cloneMatrixZeroed() {
        if (this.indices == null) {
            return new AugmentableFeatureVector(this.dictionary, new double[this.values.length]);
        }
        int[] newIndices = new int[this.indices.length];
        System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
        return new AugmentableFeatureVector(this.dictionary, newIndices, new double[this.values.length], this.values.length, this.values.length, false, false, false);
    }

    @Override
    public int singleSize() {
        return this.indices == null ? this.values.length : (this.size == 0 ? 0 : this.indices[this.size - 1]);
    }

    public SparseVector toSparseVector() {
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        return new SparseVector(this.indices, this.values, this.size, this.size, true, false, false);
    }

    public FeatureVector toFeatureVector() {
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        return new FeatureVector(this.dictionary, this.indices, this.values, this.size, this.size, true, false, false);
    }

    @Override
    public double dotProduct(DenseVector v) {
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        double ret = 0.0;
        if (this.values == null) {
            for (int i = 0; i < this.size; ++i) {
                ret += v.value(this.indices[i]);
            }
        } else if (this.indices == null) {
            for (int i = 0; i < this.size; ++i) {
                ret += this.values[i] * v.value(i);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                ret += this.values[i] * v.value(this.indices[i]);
            }
        }
        return ret;
    }

    @Override
    public final double dotProduct(SparseVector v) {
        if (v instanceof AugmentableFeatureVector) {
            return this.dotProduct((AugmentableFeatureVector)v);
        }
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        double ret = 0.0;
        int vl = 0;
        int vnl = v.numLocations();
        if (this.values == null) {
            for (int i = 0; i < this.size; ++i) {
                while (vl < vnl && v.indexAtLocation(vl) < this.indices[i]) {
                    ++vl;
                }
                if (vl >= vnl || v.indexAtLocation(vl) != this.indices[i]) continue;
                ret += v.valueAtLocation(vl);
            }
        } else if (this.indices == null) {
            for (int i = 0; i < vnl; ++i) {
                int index = v.indexAtLocation(i);
                if (index >= this.size) continue;
                ret += v.valueAtLocation(i) * this.values[index];
            }
        } else {
            for (int loc = 0; loc < this.size; ++loc) {
                while (vl < vnl && v.indexAtLocation(vl) < this.indices[loc]) {
                    ++vl;
                }
                if (vl >= vnl || v.indexAtLocation(vl) != this.indices[loc]) continue;
                ret += this.values[loc] * v.value(this.indices[loc]);
            }
        }
        return ret;
    }

    public final double dotProduct(AugmentableFeatureVector v) {
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        if (v.indices != null && v.size - 1 != v.maxSortedIndex) {
            v.sortIndices();
        }
        double ret = 0.0;
        int vl = 0;
        int vnl = v.size;
        if (this.values == null) {
            if (v.values == null) {
                for (int i = 0; i < this.size; ++i) {
                    while (vl < vnl && v.indices[vl] < this.indices[i]) {
                        ++vl;
                    }
                    if (vl >= vnl || v.indices[vl] != this.indices[i]) continue;
                    ret += 1.0;
                }
            } else {
                for (int i = 0; i < this.size; ++i) {
                    while (vl < vnl && v.indices[vl] < this.indices[i]) {
                        ++vl;
                    }
                    if (vl >= vnl || v.indices[vl] != this.indices[i]) continue;
                    ret += v.values[vl];
                }
            }
        } else if (this.indices == null) {
            for (int i = 0; i < vnl; ++i) {
                int index = v.indexAtLocation(i);
                if (index >= this.size) continue;
                ret += v.valueAtLocation(i) * this.values[index];
            }
        } else if (v.values == null) {
            for (int i = 0; i < this.size; ++i) {
                while (vl < vnl && v.indices[vl] < this.indices[i]) {
                    ++vl;
                }
                if (vl >= vnl || v.indices[vl] != this.indices[i]) continue;
                ret += this.values[i];
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                while (vl < vnl && v.indices[vl] < this.indices[i]) {
                    ++vl;
                }
                if (vl >= vnl || v.indices[vl] != this.indices[i]) continue;
                ret += this.values[i] * v.values[vl];
            }
        }
        return ret;
    }

    public void plusEquals(AugmentableFeatureVector v, double factor) {
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        if (v.indices != null && v.size - 1 != v.maxSortedIndex) {
            v.sortIndices();
        }
        int vl = 0;
        int vnl = v.size;
        assert (this.values != null);
        if (this.indices == null) {
            if (v.indices == null) {
                vnl = Math.min(vnl, this.size);
                for (int i = 0; i < vnl; ++i) {
                    int n = i;
                    this.values[n] = this.values[n] + v.values[i];
                }
            } else {
                for (int i = 0; i < vnl; ++i) {
                    int index = v.indices[i];
                    if (index >= this.values.length) continue;
                    int n = index;
                    this.values[n] = this.values[n] + v.values[i] * factor;
                    if (index < this.size) continue;
                    this.size = index + 1;
                }
            }
        } else if (v.indices == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.indices[i] >= vnl) continue;
                int n = i;
                this.values[n] = this.values[n] + v.values[this.indices[i]];
            }
        } else if (v.values == null) {
            for (int i = 0; i < this.size; ++i) {
                while (vl < vnl && v.indices[vl] < this.indices[i]) {
                    ++vl;
                }
                if (vl >= vnl || v.indices[vl] != this.indices[i]) continue;
                int n = i;
                this.values[n] = this.values[n] + factor;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                while (vl < vnl && v.indices[vl] < this.indices[i]) {
                    ++vl;
                }
                if (vl >= vnl || v.indices[vl] != this.indices[i]) continue;
                int n = i;
                this.values[n] = this.values[n] + v.values[vl] * factor;
            }
        }
    }

    public void plusEquals(SparseVector v, double factor) {
        if (v instanceof AugmentableFeatureVector) {
            this.plusEquals((AugmentableFeatureVector)v, factor);
            return;
        }
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        int vl = 0;
        assert (this.values != null);
        if (this.indices == null) {
            if (v.indices == null) {
                int s = Math.min(this.size, v.values.length);
                for (int i = 0; i < s; ++i) {
                    int n = i;
                    this.values[n] = this.values[n] + v.values[i] * factor;
                }
            } else if (v.values == null) {
                for (int i = 0; i < v.indices.length; ++i) {
                    int index = v.indices[i];
                    if (index >= this.size) continue;
                    int n = index;
                    this.values[n] = this.values[n] + factor;
                }
            } else {
                for (int i = 0; i < v.indices.length; ++i) {
                    int index = v.indices[i];
                    if (index >= this.size) continue;
                    int n = index;
                    this.values[n] = this.values[n] + v.values[i] * factor;
                }
            }
        } else if (v.indices == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.indices[i] >= v.values.length) continue;
                int n = i;
                this.values[n] = this.values[n] + v.values[this.indices[i]] * factor;
            }
        } else {
            int vnl = v.indices.length;
            if (v.values == null) {
                for (int i = 0; i < this.size; ++i) {
                    while (vl < vnl && v.indices[vl] < this.indices[i]) {
                        ++vl;
                    }
                    if (vl >= vnl || v.indices[vl] != this.indices[i]) continue;
                    int n = i;
                    this.values[n] = this.values[n] + v.values[vl] * factor;
                }
            } else {
                for (int i = 0; i < this.size; ++i) {
                    while (vl < vnl && v.indices[vl] < this.indices[i]) {
                        ++vl;
                    }
                    if (vl >= vnl || v.indices[vl] != this.indices[i]) continue;
                    int n = i;
                    this.values[n] = this.values[n] + v.values[vl] * factor;
                }
            }
        }
    }

    public void plusEquals(SparseVector v) {
        this.plusEquals(v, 1.0);
    }

    @Override
    public void setAll(double v) {
        assert (this.values != null);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = v;
        }
    }

    @Override
    public double oneNorm() {
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        double ret = 0.0;
        if (this.values == null) {
            return this.size;
        }
        for (int i = 0; i < this.size; ++i) {
            ret += this.values[i];
        }
        return ret;
    }

    @Override
    public double twoNorm() {
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        double ret = 0.0;
        if (this.values == null) {
            return Math.sqrt(this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            ret += this.values[i] * this.values[i];
        }
        return Math.sqrt(ret);
    }

    @Override
    public double infinityNorm() {
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        if (this.values == null) {
            return 1.0;
        }
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.size; ++i) {
            if (!(Math.abs(this.values[i]) > max)) continue;
            max = Math.abs(this.values[i]);
        }
        return max;
    }

    @Override
    public void print() {
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        super.print();
    }

    @Override
    protected void sortIndices() {
        if (this.indices == null) {
            return;
        }
        if (this.size == 0) {
            this.size = this.indices.length;
            this.maxSortedIndex = -1;
        }
        for (int i = this.maxSortedIndex + 1; i < this.size; ++i) {
            for (int j = i; j > 0; --j) {
                if (this.indices[j] >= this.indices[j - 1]) continue;
                int f = this.indices[j];
                this.indices[j] = this.indices[j - 1];
                this.indices[j - 1] = f;
                if (this.values == null) continue;
                double v = this.values[j];
                this.values[j] = this.values[j - 1];
                this.values[j - 1] = v;
            }
        }
        this.removeDuplicates(0);
        this.maxSortedIndex = this.size - 1;
    }

    @Override
    protected void removeDuplicates(@Var int numDuplicates) {
        if (this.indices == null) {
            return;
        }
        if (numDuplicates == 0) {
            for (int i = 1; i < this.size; ++i) {
                if (this.indices[i - 1] != this.indices[i]) continue;
                ++numDuplicates;
            }
        }
        if (numDuplicates == 0) {
            return;
        }
        assert (this.indices.length - numDuplicates > 0) : "size=" + this.size + " indices.length=" + this.indices.length + " numDuplicates=" + numDuplicates;
        int[] newIndices = new int[this.size - numDuplicates];
        double[] newValues = this.values == null ? null : new double[this.size - numDuplicates];
        newIndices[0] = this.indices[0];
        assert (this.indices.length >= this.size);
        int j = 0;
        for (int i = 0; i < this.size - 1; ++i) {
            if (this.indices[i] == this.indices[i + 1]) {
                if (this.values != null) {
                    int n = j;
                    newValues[n] = newValues[n] + this.values[i];
                }
            } else {
                newIndices[j] = this.indices[i];
                if (this.values != null) {
                    int n = j;
                    newValues[n] = newValues[n] + this.values[i];
                }
                ++j;
            }
            if (i != this.size - 2) continue;
            if (this.values != null) {
                int n = j;
                newValues[n] = newValues[n] + this.values[i + 1];
            }
            newIndices[j] = this.indices[i + 1];
        }
        this.indices = newIndices;
        this.values = newValues;
        this.size -= numDuplicates;
        this.maxSortedIndex = this.size - 1;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeInt(this.size);
        out.writeInt(this.maxSortedIndex);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.size = in.readInt();
        this.maxSortedIndex = in.readInt();
    }
}

