/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.constraints;

import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.fst.semi_supervised.constraints.OneLabelGEConstraints;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.Maths;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;

public class OneLabelKLGEConstraints
extends OneLabelGEConstraints {
    public OneLabelKLGEConstraints() {
    }

    private OneLabelKLGEConstraints(IntObjectHashMap<OneLabelGEConstraints.OneLabelGEConstraint> constraints, StateLabelMap map) {
        super(constraints, map);
    }

    @Override
    public GEConstraint copy() {
        return new OneLabelKLGEConstraints(this.constraints, this.map);
    }

    @Override
    public void addConstraint(int fi, double[] target, double weight) {
        assert (Maths.almostEquals(MatrixOps.sum(target), 1.0));
        this.constraints.put(fi, new OneLabelGEKLConstraint(target, weight));
    }

    @Override
    public double getValue() {
        double value = 0.0;
        for (ObjectCursor fi : this.constraints.values()) {
            OneLabelGEConstraints.OneLabelGEConstraint constraint = (OneLabelGEConstraints.OneLabelGEConstraint)fi.value;
            if (!(constraint.count > 0.0)) continue;
            double constraintValue = 0.0;
            for (int labelIndex = 0; labelIndex < this.map.getNumLabels(); ++labelIndex) {
                if (!(constraint.target[labelIndex] > 0.0)) continue;
                if (constraint.expectation[labelIndex] == 0.0) {
                    return Double.NEGATIVE_INFINITY;
                }
                constraintValue += constraint.target[labelIndex] * (Math.log(constraint.expectation[labelIndex] / constraint.count) - Math.log(constraint.target[labelIndex]));
            }
            assert (!Double.isNaN(constraintValue) && !Double.isInfinite(constraintValue));
            value += constraintValue * constraint.weight;
        }
        return value;
    }

    protected class OneLabelGEKLConstraint
    extends OneLabelGEConstraints.OneLabelGEConstraint {
        public OneLabelGEKLConstraint(double[] target, double weight) {
            super(OneLabelKLGEConstraints.this, target, weight);
        }

        @Override
        public double getValue(int li) {
            assert (this.count != 0.0);
            if (this.target[li] == 0.0 && this.expectation[li] == 0.0) {
                return 0.0;
            }
            return this.weight * (this.target[li] / this.expectation[li]);
        }
    }
}

