## ----include = FALSE----------------------------------------------------------
library(jfa)

## -----------------------------------------------------------------------------
data(BuildIt)

## -----------------------------------------------------------------------------
# Record sampling
sample <- selection(data = BuildIt, size = 100, units = "items", method = "interval", start = 1)
head(sample$sample, n = 6)

## -----------------------------------------------------------------------------
# Monetary unit sampling
sample <- selection(data = BuildIt, size = 100, units = "values", method = "interval", values = "bookValue", start = 1)
head(sample$sample, n = 6)

## -----------------------------------------------------------------------------
# Record sampling
set.seed(1)
sample <- selection(data = BuildIt, size = 100, units = "items", method = "cell")
head(sample$sample, n = 6)

## -----------------------------------------------------------------------------
# Monetary unit sampling
set.seed(1)
sample <- selection(data = BuildIt, size = 100, units = "values", method = "cell", values = "bookValue")
head(sample$sample, n = 6)

## -----------------------------------------------------------------------------
# Record sampling
set.seed(1)
sample <- selection(data = BuildIt, size = 100, units = "items", method = "random")
head(sample$sample, n = 6)

## -----------------------------------------------------------------------------
# Monetary unit sampling
set.seed(1)
sample <- selection(data = BuildIt, size = 100, units = "values", method = "random", values = "bookValue")
head(sample$sample, n = 6)

## -----------------------------------------------------------------------------
# Monetary unit sampling
set.seed(1)
sample <- selection(data = BuildIt, size = 100, units = "values", method = "sieve", values = "bookValue")
head(sample$sample, n = 6)

## -----------------------------------------------------------------------------
# Ordering population from lowest 'bookValue' to highest 'bookValue' before MUS
set.seed(1)
sample <- selection(
  data = BuildIt, size = 100,
  units = "values", values = "bookValue",
  order = "bookValue", decreasing = FALSE
)
head(sample$sample, n = 6)

## -----------------------------------------------------------------------------
# Randomly shuffle population items before MUS
set.seed(1)
sample <- selection(
  data = BuildIt, size = 100,
  units = "values", values = "bookValue", randomize = TRUE
)
head(sample$sample, n = 6)

