/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCMAR;

import keel.Algorithms.Associative_Classification.ClassifierCMAR.PtreeNode;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.PtreeNodeTop;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.TotalSupportTree;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.TtreeNode;

public class PartialSupportTree
extends TotalSupportTree {
    private short[] zeroitemSet = null;
    private PtreeNodeTop[] startPtreeRef = null;
    protected PtreeRecord[][] startPtreeTable = null;
    private int[] pTreeNodesOfCardinalityN = null;
    private int[] pTreeTableMarker = null;
    private int numberOfNodeUpdates = 0;

    public PartialSupportTree(double minConf, double minSup, int delta) {
        super(minConf, minSup, delta);
    }

    public void createPtree() {
        int index;
        System.out.println("GENERATING P-TREE\n------------------");
        this.startPtreeRef = new PtreeNodeTop[this.numOneItemSets + 1];
        this.startPtreeTable = new PtreeRecord[this.numOneItemSets + 1][];
        this.pTreeNodesOfCardinalityN = new int[this.numOneItemSets + 1];
        this.pTreeTableMarker = new int[this.numOneItemSets + 1];
        for (index = 0; index < this.startPtreeRef.length; ++index) {
            this.startPtreeRef[index] = null;
        }
        for (index = 0; index < this.dataArray.length; ++index) {
            if (this.dataArray[index] == null) continue;
            this.addToPtreeTopLevel(this.dataArray[index]);
        }
        System.out.println("Creating P-tree table");
        this.createPtreeTable();
    }

    private void addToPtreeTopLevel(short[] itemSet) {
        short index = itemSet[0];
        int itemSetLength = itemSet.length;
        if (itemSetLength == 1) {
            if (this.startPtreeRef[index] == null) {
                this.startPtreeRef[index] = new PtreeNodeTop();
                this.pTreeNodesOfCardinalityN[1] = this.pTreeNodesOfCardinalityN[1] + 1;
            } else {
                ++this.startPtreeRef[index].support;
            }
            ++this.numberOfNodeUpdates;
        } else {
            if (this.startPtreeRef[index] == null) {
                this.startPtreeRef[index] = new PtreeNodeTop();
                this.pTreeNodesOfCardinalityN[1] = this.pTreeNodesOfCardinalityN[1] + 1;
            } else {
                ++this.startPtreeRef[index].support;
            }
            ++this.numberOfNodeUpdates;
            this.addToPtree(0, 2, itemSetLength, this.startPtreeRef[index].childRef, this.realloc3(itemSet), index, null);
        }
    }

    public void addToPtree(int flag, int parentLength, int itemSetLength, PtreeNode linkRef, short[] itemSet, int topIndex, PtreeNode oldRef) {
        if (linkRef == null) {
            PtreeNode newRef = this.createPtreeNode(itemSet, itemSetLength);
            this.addSupport2(flag, newRef, topIndex, oldRef);
        } else {
            switch (this.checkItemSets(itemSet, linkRef.itemSet)) {
                case 1: {
                    ++this.numberOfNodeUpdates;
                    ++linkRef.support;
                    break;
                }
                case 2: {
                    this.beforeAndSubset(flag, itemSetLength, linkRef, itemSet, topIndex, oldRef);
                    break;
                }
                case 3: {
                    this.beforeAndNotSubset(flag, parentLength, itemSetLength, linkRef, itemSet, topIndex, oldRef);
                    break;
                }
                case 4: {
                    this.afterAndSuperset(parentLength, itemSetLength, linkRef, itemSet);
                    break;
                }
                case 5: {
                    this.afterAndNotSuperset(flag, parentLength, itemSetLength, linkRef, itemSet, topIndex, oldRef);
                    break;
                }
            }
        }
    }

    private void beforeAndSubset(int flag, int itemSetLength, PtreeNode linkRef, short[] currentitemSet, int topIndex, PtreeNode oldRef) {
        PtreeNode newRef = this.createPtreeNode(currentitemSet, itemSetLength);
        newRef.support += linkRef.support;
        ++this.numberOfNodeUpdates;
        newRef.childRef = linkRef;
        this.addSupport2(flag, newRef, topIndex, oldRef);
        linkRef.itemSet = this.realloc4(linkRef.itemSet, currentitemSet);
        this.checkSiblingBranch(linkRef, currentitemSet, newRef);
    }

    private void beforeAndNotSubset(int flag, int parentLength, int itemSetLength, PtreeNode linkRef, short[] currentItemSet, int topIndex, PtreeNode oldRef) {
        short[] subsetItemSet = this.checkForLeadingSubString(currentItemSet, linkRef.itemSet);
        if (subsetItemSet != null) {
            PtreeNode newParentRef = this.createPtreeNode(subsetItemSet, subsetItemSet.length + parentLength - 1);
            newParentRef.support = linkRef.support + 1;
            this.addSupport2(flag, newParentRef, topIndex, oldRef);
            currentItemSet = this.realloc4(currentItemSet, subsetItemSet);
            newParentRef.childRef = this.createPtreeNode(currentItemSet, itemSetLength);
            newParentRef.childRef.siblingRef = linkRef;
            this.checkSiblingBranch(newParentRef.childRef, subsetItemSet, newParentRef);
        } else {
            PtreeNode newSiblingRef = this.createPtreeNode(currentItemSet, itemSetLength);
            newSiblingRef.siblingRef = linkRef;
            this.addSupport2(flag, newSiblingRef, topIndex, oldRef);
        }
    }

    private void afterAndSuperset(int parentLength, int itemSetLength, PtreeNode linkRef, short[] currentItemSet) {
        ++this.numberOfNodeUpdates;
        ++linkRef.support;
        if (linkRef.childRef == null) {
            PtreeNode newRef;
            linkRef.childRef = newRef = this.createPtreeNode(this.realloc4(currentItemSet, linkRef.itemSet), itemSetLength);
        } else {
            this.addToPtree(1, parentLength + linkRef.itemSet.length, itemSetLength, linkRef.childRef, this.realloc4(currentItemSet, linkRef.itemSet), 0, linkRef);
        }
    }

    private void afterAndNotSuperset(int flag, int parentLength, int itemSetLength, PtreeNode linkRef, short[] currentItemSet, int topIndex, PtreeNode oldRef) {
        if (linkRef.siblingRef == null) {
            this.afterAndNotSuperset1(flag, parentLength, itemSetLength, linkRef, currentItemSet, topIndex, oldRef);
        } else {
            this.afterAndNotSuperset2(flag, parentLength, itemSetLength, linkRef, currentItemSet, topIndex, oldRef);
        }
    }

    private void afterAndNotSuperset1(int flag, int parentLength, int itemSetLength, PtreeNode linkRef, short[] currentItemSet, int topIndex, PtreeNode oldRef) {
        short[] subsetItemSet = this.checkForLeadingSubString(currentItemSet, linkRef.itemSet);
        if (subsetItemSet != null) {
            PtreeNode newParent = this.createPtreeNode(subsetItemSet, subsetItemSet.length + parentLength - 1);
            newParent.support = linkRef.support + 1;
            this.addSupport2(flag, newParent, topIndex, oldRef);
            linkRef.itemSet = this.realloc4(linkRef.itemSet, subsetItemSet);
            newParent.childRef = linkRef;
            linkRef.siblingRef = this.createPtreeNode(this.realloc4(currentItemSet, subsetItemSet), itemSetLength);
        } else {
            linkRef.siblingRef = this.createPtreeNode(currentItemSet, itemSetLength);
        }
    }

    private void afterAndNotSuperset2(int flag, int parentLength, int itemSetLength, PtreeNode linkRef, short[] currentItemSet, int topIndex, PtreeNode oldRef) {
        short[] subsetItemSet = this.checkForLeadingSubString(currentItemSet, linkRef.itemSet);
        if (subsetItemSet != null) {
            PtreeNode newParentRef = this.createPtreeNode(subsetItemSet, subsetItemSet.length + parentLength - 1);
            newParentRef.support = linkRef.support + 1;
            this.addSupport2(flag, newParentRef, topIndex, oldRef);
            linkRef.itemSet = this.realloc4(linkRef.itemSet, subsetItemSet);
            newParentRef.childRef = linkRef;
            PtreeNode tempRef = linkRef.siblingRef;
            linkRef.siblingRef = this.createPtreeNode(currentItemSet, itemSetLength);
            linkRef.siblingRef.siblingRef = tempRef;
            this.checkSiblingBranch(newParentRef.childRef, subsetItemSet, newParentRef);
        } else {
            this.addToPtree(2, parentLength, itemSetLength, linkRef.siblingRef, currentItemSet, 0, linkRef);
        }
    }

    private void addSupport2(int flag, PtreeNode newRef, int topIndex, PtreeNode oldRef) {
        switch (flag) {
            case 0: {
                this.startPtreeRef[topIndex].childRef = newRef;
                break;
            }
            case 1: {
                oldRef.childRef = newRef;
                break;
            }
            case 2: {
                oldRef.siblingRef = newRef;
                break;
            }
            default: {
                System.out.println("ERROR: Unidentified flag in addSupport\n");
            }
        }
    }

    private void checkSiblingBranch(PtreeNode linkRef, short[] parentItemSet, PtreeNode newRef) {
        if (linkRef.siblingRef != null) {
            if (!this.isSubset(parentItemSet, linkRef.siblingRef.itemSet)) {
                newRef.siblingRef = linkRef.siblingRef;
                linkRef.siblingRef = null;
            } else {
                linkRef.siblingRef.itemSet = this.realloc4(linkRef.siblingRef.itemSet, parentItemSet);
                PtreeNode markerRef = linkRef.siblingRef;
                PtreeNode localLinkRef = linkRef.siblingRef.siblingRef;
                while (localLinkRef != null) {
                    if (!this.isSubset(parentItemSet, localLinkRef.itemSet)) {
                        newRef.siblingRef = localLinkRef;
                        markerRef.siblingRef = null;
                        break;
                    }
                    localLinkRef.siblingRef.itemSet = this.realloc4(localLinkRef.siblingRef.itemSet, parentItemSet);
                    markerRef = localLinkRef;
                    localLinkRef = localLinkRef.siblingRef;
                }
            }
        }
    }

    private PtreeNode createPtreeNode(short[] itemSet, int level) {
        int n = level;
        this.pTreeNodesOfCardinalityN[n] = this.pTreeNodesOfCardinalityN[n] + 1;
        return new PtreeNode(itemSet);
    }

    public PtreeNodeTop[] getStartOfPtree() {
        return this.startPtreeRef;
    }

    public int getNumPtreeNodes() {
        return this.calculateNumNodes(this.startPtreeRef);
    }

    public void createPtreeTable() {
        int index;
        for (index = 1; index < this.pTreeNodesOfCardinalityN.length; ++index) {
            this.startPtreeTable[index] = this.pTreeNodesOfCardinalityN[index] == 0 ? null : new PtreeRecord[this.pTreeNodesOfCardinalityN[index]];
        }
        for (index = 0; index < this.startPtreeRef.length; ++index) {
            if (this.startPtreeRef[index] == null) continue;
            short[] itemSet = new short[]{(short)index};
            this.addToPtreeArray(null, itemSet, this.startPtreeRef[index].support, 1);
            this.createPtreeTable2(this.startPtreeRef[index].childRef, itemSet, 1);
            this.startPtreeRef[index] = null;
        }
    }

    private void createPtreeTable2(PtreeNode linkPtreeRef, short[] totalpTreeItemSet, int currentLevel) {
        if (linkPtreeRef != null) {
            int lastElementIndex = linkPtreeRef.itemSet.length - 1;
            int level = currentLevel + lastElementIndex + 1;
            this.addToPtreeArray(linkPtreeRef.itemSet, totalpTreeItemSet, linkPtreeRef.support, level);
            this.createPtreeTable2(linkPtreeRef.childRef, this.append(totalpTreeItemSet, linkPtreeRef.itemSet), level);
            linkPtreeRef.childRef = null;
            this.createPtreeTable2(linkPtreeRef.siblingRef, totalpTreeItemSet, currentLevel);
            linkPtreeRef.siblingRef = null;
        }
    }

    private void addToPtreeArray(short[] pTreeNodeLabel, short[] pTreeItemSet, int support, int level) {
        this.startPtreeTable[level][this.pTreeTableMarker[level]] = pTreeNodeLabel == null ? new PtreeRecord(pTreeItemSet, pTreeItemSet, support) : new PtreeRecord(pTreeNodeLabel, this.append(pTreeItemSet, pTreeNodeLabel), support);
        int n = level;
        this.pTreeTableMarker[n] = this.pTreeTableMarker[n] + 1;
    }

    public void createTotalSupportTree() {
        System.out.println("APRIORI-TFP WITH X-CHECKING\n---------------------------");
        System.out.println("Minimum support threshold = " + this.twoDecPlaces(this.support) + "% " + "(" + this.twoDecPlaces(this.minSupport) + " (records)");
        if (this.numOneItemSets == 0) {
            return;
        }
        this.startTtreeRef = null;
        this.numFrequentsets = 0;
        this.createTtreeTopLevel();
        this.generateLevel2();
        this.createTtreeLevelN();
    }

    @Override
    protected void createTtreeTopLevel2() {
        for (int index = 1; index < this.startPtreeTable.length; ++index) {
            if (this.startPtreeTable[index] == null) continue;
            this.createTtreeTopLevel3(this.startPtreeTable[index]);
        }
        this.startPtreeTable[1] = null;
    }

    protected void createTtreeTopLevel3(PtreeRecord[] pTreeTableLevel) {
        for (int index = 0; index < pTreeTableLevel.length; ++index) {
            this.createTtreeTopLevel4(pTreeTableLevel[index].pTreeNodeLabel, pTreeTableLevel[index].support);
        }
    }

    private void createTtreeTopLevel4(short[] pTreeNodeLabel, int pTreeNodeSupport) {
        for (int index = 0; index < pTreeNodeLabel.length; ++index) {
            this.startTtreeRef[pTreeNodeLabel[index]].support += pTreeNodeSupport;
            ++this.numUpdates;
        }
    }

    protected void createTtreeLevelN() {
        int nextLevel = 2;
        while (this.nextLevelExists) {
            this.addSupportToTtreeLevelN(nextLevel);
            this.startPtreeTable[nextLevel] = null;
            this.pruneLevelN(this.startTtreeRef, nextLevel);
            this.nextLevelExists = false;
            this.generateLevelN(this.startTtreeRef, nextLevel, null);
            ++nextLevel;
        }
        System.out.println("Levels in T-tree = " + nextLevel);
    }

    protected void addSupportToTtreeLevelN(int level) {
        for (int index1 = level; index1 < this.startPtreeTable.length; ++index1) {
            if (this.startPtreeTable[index1] == null) continue;
            for (int index2 = 0; index2 < this.pTreeNodesOfCardinalityN[index1]; ++index2) {
                this.addSupportToTtreeLevelN(this.startTtreeRef, level, this.startPtreeTable[index1][index2].pTreeNodeLabel, this.startPtreeTable[index1][index2].pTreeItemSet, this.startPtreeTable[index1][index2].support);
            }
        }
    }

    private void addSupportToTtreeLevelN(TtreeNode[] linkRef, int level, short[] pTreeNodeLabel, short[] pTreeItemSet, int support) {
        int tTreeLength = linkRef.length;
        if (level == 1) {
            for (int index = 0; index < pTreeItemSet.length && pTreeItemSet[index] < tTreeLength; ++index) {
                if (linkRef[pTreeItemSet[index]] == null) continue;
                linkRef[pTreeItemSet[index]].support += support;
                ++this.numUpdates;
            }
        } else {
            int scLength = pTreeNodeLabel.length;
            for (int index = 0; index < scLength && pTreeNodeLabel[index] < tTreeLength; ++index) {
                if (linkRef[pTreeNodeLabel[index]] == null || linkRef[pTreeNodeLabel[index]].childRef == null) continue;
                this.addSupportToTtreeLevelN(linkRef[pTreeNodeLabel[index]].childRef, level - 1, pTreeItemSet, pTreeItemSet, support);
            }
        }
    }

    public void outputPtree() {
        System.out.println();
        this.outputPtree1(this.startPtreeRef);
    }

    public void outputPtree1(PtreeNodeTop[] linkPtreeRef) {
        int counter = 1;
        for (int index = 0; index < linkPtreeRef.length; ++index) {
            if (linkPtreeRef[index] == null) continue;
            this.outputPtree2(index, linkPtreeRef[index], counter);
            ++counter;
        }
    }

    private void outputPtree2(int index, PtreeNodeTop linkRef, int counter) {
        String newNode = Integer.toString(counter);
        System.out.print("(" + newNode + ")");
        short[] itemSet = new short[]{(short)index};
        this.outputItemSet(itemSet);
        System.out.println("support = " + linkRef.support);
        this.outputPtree3(linkRef.childRef, newNode, 1);
    }

    private void outputPtree3(PtreeNode linkRef, String node, int counter) {
        if (linkRef != null) {
            String newNode;
            if (node == "start") {
                newNode = Integer.toString(counter);
            } else {
                newNode = node.concat(".");
                newNode = newNode.concat(Integer.toString(counter));
            }
            System.out.print("(" + newNode + ")");
            this.outputItemSet(linkRef.itemSet);
            System.out.println("support = " + linkRef.support);
            this.outputPtree3(linkRef.childRef, newNode, 1);
            this.outputPtree3(linkRef.siblingRef, node, ++counter);
        }
    }

    public void outputPtreeStats() {
        System.out.println("P-TREE STATISTICS\n-----------------");
        System.out.println(this.calculateStorage(this.startPtreeRef) + " (Bytes) storage");
        System.out.println(this.calculateNumNodes(this.startPtreeRef) + " nodess");
        System.out.println(this.numberOfNodeUpdates + " support value increments");
    }

    public void outputPtreeStorage() {
        int storage = this.calculateStorage(this.startPtreeRef);
        System.out.println("P-tree storage = " + storage + " (Bytes)");
    }

    private int calculateStorage(PtreeNodeTop[] linkPtreeRef) {
        int storage = 4;
        for (int index = 1; index < linkPtreeRef.length; ++index) {
            if (linkPtreeRef[index] != null) {
                storage = this.calculateStorage(storage, linkPtreeRef[index]);
            }
            storage += 4;
        }
        return storage;
    }

    private int calculateStorage(int storage, PtreeNodeTop linkRef) {
        return this.calculateStorage(storage += 8, linkRef.childRef);
    }

    private int calculateStorage(int storage, PtreeNode linkRef) {
        if (linkRef != null) {
            storage = storage + 12 + linkRef.itemSet.length * 2;
            storage = this.calculateStorage(storage, linkRef.childRef);
            storage = this.calculateStorage(storage, linkRef.siblingRef);
        }
        return storage;
    }

    public void outputNumNodes() {
        int num = 0;
        num = this.calculateNumNodes(this.startPtreeRef);
        System.out.println("Number of P-tree nodes = " + num);
        System.out.println("Number of P-tree support value increments = " + this.numberOfNodeUpdates);
    }

    private int calculateNumNodes(PtreeNodeTop[] linkPtreeRef) {
        int num = 0;
        for (int index = 1; index < linkPtreeRef.length; ++index) {
            if (linkPtreeRef[index] == null) continue;
            num = 1 + this.calculateNumNodes(num, linkPtreeRef[index].childRef);
        }
        return num;
    }

    private int calculateNumNodes(int num, PtreeNode linkRef) {
        if (linkRef != null) {
            ++num;
            num = this.calculateNumNodes(num, linkRef.childRef);
            num = this.calculateNumNodes(num, linkRef.siblingRef);
        }
        return num;
    }

    public void outputPtreeTable() {
        int index1;
        System.out.println("P-ree Nodes of cardinality [N]: ");
        for (index1 = 1; index1 < this.pTreeNodesOfCardinalityN.length; ++index1) {
            System.out.println("[" + index1 + "] " + this.pTreeNodesOfCardinalityN[index1]);
        }
        System.out.println("Marker values on completion of P-tree table generation: ");
        for (index1 = 1; index1 < this.pTreeTableMarker.length; ++index1) {
            System.out.println("[" + index1 + "] " + this.pTreeTableMarker[index1]);
        }
        for (index1 = 1; index1 < this.startPtreeTable.length; ++index1) {
            System.out.println("LEVEL = " + index1);
            if (this.startPtreeTable[index1] == null) {
                System.out.print("null");
            } else {
                for (int index2 = 0; index2 < this.pTreeTableMarker[index1]; ++index2) {
                    System.out.print("Node label = ");
                    this.outputItemSet(this.startPtreeTable[index1][index2].pTreeNodeLabel);
                    System.out.print(" Itemset = ");
                    this.outputItemSet(this.startPtreeTable[index1][index2].pTreeItemSet);
                    System.out.println(" sup = " + this.startPtreeTable[index1][index2].support);
                }
            }
            System.out.println();
        }
    }

    public void outputPtreeTableStats() {
        int storage = 0;
        int nodeTotal = 0;
        for (int index1 = 1; index1 < this.startPtreeTable.length; ++index1) {
            int nodeCounter = 0;
            if (this.startPtreeTable[index1] == null) {
                storage += 4;
            } else {
                for (int index2 = 0; index2 < this.pTreeTableMarker[index1]; ++index2) {
                    ++nodeCounter;
                    storage = storage + 4 + this.startPtreeTable[index1][index2].pTreeNodeLabel.length * 2;
                    storage += this.startPtreeTable[index1][index2].pTreeItemSet.length * 2;
                }
            }
            nodeTotal += nodeCounter;
        }
        System.out.println("P-tree Table Storage = " + storage + " (" + nodeTotal + " nodes)");
    }

    protected class PtreeRecord {
        private short[] pTreeNodeLabel = null;
        private short[] pTreeItemSet = null;
        private int support = 0;

        private PtreeRecord(short[] nodeLabel, short[] itemSet, int sup) {
            this.pTreeNodeLabel = nodeLabel;
            this.pTreeItemSet = itemSet;
            this.support = sup;
        }
    }
}

