/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCMAR;

import keel.Algorithms.Associative_Classification.ClassifierCMAR.AprioriTFPclass;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.TtreeNode;

public class AprioriTFP_CMAR
extends AprioriTFPclass {
    private final int MAX_NUM_CARS = 1000000;
    private int numCarsSoFar = 0;

    public AprioriTFP_CMAR(double minConf, double minSup, int delta) {
        super(minConf, minSup, delta);
    }

    public void startCMARclassification() {
        System.out.println("START APRIORI-TFP CMAR\n--------------------------");
        this.startCARgeneration();
        this.currentRlist.outputNumCMARrules();
        System.out.println("prune CARS");
        this.currentRlist.pruneUsingCover(this.copyItemSet(this.dataArray));
    }

    public double startCMARclassificationWithOutput() {
        System.out.println("START APRIORI-TFP CMAR\n--------------------------");
        this.startCARgeneration();
        this.currentRlist.outputNumCMARrules();
        System.out.println("prune CARS");
        this.currentRlist.pruneUsingCover(this.copyItemSet(this.dataArray));
        return this.testClassificationWithOutput();
    }

    private void startCARgeneration() {
        this.outputSuppAndConf();
        this.minSupport = (double)this.numRowsInTrainingSet * this.support / 100.0;
        System.out.println("Num rows in training set = " + this.numRows + ", reduced minimum support = " + this.minSupport);
        this.currentRlist.setNumRows(this.numRows);
        this.currentRlist.setNumClasses(this.numClasses);
        this.currentRlist.setNumOneItemSets(this.numOneItemSets);
        this.currentRlist.startRulelist = null;
        this.numCarsSoFar = 0;
        this.createPtree();
        this.createTotalSupportTree();
    }

    private void generateCARs(int level) {
        for (int index = this.numOneItemSets - this.numClasses + 1; index <= this.numOneItemSets; ++index) {
            if (this.startTtreeRef[index] == null || this.startTtreeRef[index].childRef == null || !((double)this.startTtreeRef[index].support >= this.minSupport)) continue;
            short[] consequent = new short[]{(short)index};
            this.generateCARs(null, index, level - 1, consequent, this.startTtreeRef[index].childRef);
        }
    }

    protected void generateCARs(short[] itemSetSofar, int size, int level, short[] consequent, TtreeNode[] linkRef) {
        if (linkRef == null) {
            return;
        }
        if (level == 1) {
            for (int index = 1; index < size; ++index) {
                short[] tempItemSet;
                double suppForAntecedent;
                double confidenceForCAR;
                if (linkRef[index] == null || !((confidenceForCAR = this.getConfidence(suppForAntecedent = (double)this.getSupportForItemSetInTtree(tempItemSet = this.realloc2(itemSetSofar, (short)index)), (double)linkRef[index].support)) >= this.confidence)) continue;
                ++this.numCarsSoFar;
                double suppForConcequent = this.getSupportForItemSetInTtree(consequent);
                this.currentRlist.insertRinRlistCMARranking(tempItemSet, consequent, suppForAntecedent, suppForConcequent, linkRef[index].support, confidenceForCAR);
            }
            return;
        }
        for (int index = 1; index < size; ++index) {
            if (linkRef[index] == null || linkRef[index].childRef == null) continue;
            short[] tempItemSet = this.realloc2(itemSetSofar, (short)index);
            this.generateCARs(tempItemSet, index, level - 1, consequent, linkRef[index].childRef);
        }
    }

    @Override
    protected void createTtreeLevelN() {
        int nextLevel = 2;
        while (this.nextLevelExists) {
            this.addSupportToTtreeLevelN(nextLevel);
            this.pruneLevelN(this.startTtreeRef, nextLevel);
            this.generateCARs(nextLevel);
            if (this.numFrequentsets > 1000000) {
                System.out.println("Number of frequent sets (" + this.numFrequentsets + ") generted so far " + "exceeds limit of " + 1000000 + ", generation process stopped!");
                break;
            }
            this.nextLevelExists = false;
            this.generateLevelN(this.startTtreeRef, nextLevel, null);
            ++nextLevel;
        }
        System.out.println("Levels in T-tree = " + nextLevel);
    }

    private double testClassification() {
        int correctClassCounter = 0;
        int wrongClassCounter = 0;
        int unclassifiedCounter = 0;
        if (this.testDataArray == null) {
            System.out.println("WARNING: No test data");
            return 0.0;
        }
        if (this.currentRlist.startCMARrulelist == null) {
            System.out.println("No classification rules generated!");
            return 0.0;
        }
        for (int index = 0; index < this.testDataArray.length; ++index) {
            short classResult = this.currentRlist.classifyRecordWCS(this.testDataArray[index]);
            if (classResult == 0) {
                ++unclassifiedCounter;
                continue;
            }
            short classActual = this.getLastElement(this.testDataArray[index]);
            if (classResult == classActual) {
                ++correctClassCounter;
                continue;
            }
            ++wrongClassCounter;
        }
        double accuracy = (double)correctClassCounter * 100.0 / (double)this.testDataArray.length;
        System.out.println("Accuracy = " + this.twoDecPlaces(accuracy) + "%");
        return accuracy;
    }

    private double testClassificationWithOutput() {
        int correctClassCounter = 0;
        int wrongClassCounter = 0;
        int unclassifiedCounter = 0;
        if (this.testDataArray == null) {
            System.out.println("WARNING: No test data");
            return 0.0;
        }
        if (this.currentRlist.startCMARrulelist == null) {
            System.out.println("No classification rules generated!");
            return 0.0;
        }
        for (int index = 0; index < this.testDataArray.length; ++index) {
            short classResult = this.currentRlist.classifyRecordWCS(this.testDataArray[index]);
            if (classResult == 0) {
                ++unclassifiedCounter;
                continue;
            }
            short classActual = this.getLastElement(this.testDataArray[index]);
            if (classResult == classActual) {
                ++correctClassCounter;
                continue;
            }
            ++wrongClassCounter;
        }
        double accuracy = (double)correctClassCounter * 100.0 / (double)this.testDataArray.length;
        System.out.println("Correct classifications = " + correctClassCounter);
        System.out.println("unclassified            = " + unclassifiedCounter);
        System.out.println("Wrong classifications   = " + wrongClassCounter);
        System.out.println("Number of test cases    = " + this.testDataArray.length);
        System.out.println("Accuracy                = " + this.twoDecPlaces(accuracy) + "%");
        return accuracy;
    }
}

