/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Lazy_Learning.CamNN;

import java.util.StringTokenizer;
import keel.Algorithms.Lazy_Learning.LazyAlgorithm;
import org.core.Files;

public class CamNN
extends LazyAlgorithm {
    int K;
    double[][] V;
    double[][] W;
    double[] G;
    double L;
    double c1;
    double c2;
    double[] A;
    double[] B;
    double[][] TAU;
    int N;
    double gammaValue;
    double gammaNextValue;

    public CamNN(String script) {
        this.readDataFiles(script);
        this.name = "Cam NN";
        this.V = new double[this.inputAtt][this.K];
        this.W = new double[this.inputAtt][this.K];
        this.G = new double[this.inputAtt];
        this.A = new double[this.trainData.length];
        this.B = new double[this.trainData.length];
        this.TAU = new double[this.trainData.length][this.inputAtt];
        this.setInitialTime();
    }

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.K = Integer.parseInt(tokens.nextToken().substring(1));
    }

    public void precalculateParameters() {
        int dimension = this.inputAtt > 16 ? 16 : this.inputAtt;
        if (dimension % 2 == 0) {
            this.N = dimension / 2;
            this.gammaValue = this.fact(this.N - 1);
            this.gammaNextValue = Math.sqrt(Math.PI) / Math.pow(2.0, this.N);
            this.gammaNextValue *= this.doubleFact(2 * this.N - 1);
        } else {
            this.N = dimension / 2;
            this.gammaValue = Math.sqrt(Math.PI) / Math.pow(2.0, this.N);
            this.gammaValue *= this.doubleFact(2 * this.N - 1);
            this.gammaNextValue = this.fact(this.N + 1);
        }
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (int instance = 0; instance < this.trainData.length; ++instance) {
            double module;
            int j;
            int i;
            for (i = 0; i < this.K; ++i) {
                nearestN[i] = -1;
                minDist[i] = Double.MAX_VALUE;
            }
            for (i = 0; i < this.trainData.length; ++i) {
                double dist = this.euclideanDistance(this.trainData[instance], this.trainData[i]);
                if (!(dist > 0.0)) continue;
                boolean stop = false;
                for (j = 0; j < this.K && !stop; ++j) {
                    if (!(dist < minDist[j])) continue;
                    for (int l = this.K - 1; l >= j + 1; --l) {
                        minDist[l] = minDist[l - 1];
                        nearestN[l] = nearestN[l - 1];
                    }
                    minDist[j] = dist;
                    nearestN[j] = i;
                    stop = true;
                }
            }
            for (i = 0; i < this.inputAtt; ++i) {
                for (j = 0; j < this.K; ++j) {
                    this.V[i][j] = this.trainData[nearestN[j]][i] - this.trainData[instance][i];
                }
            }
            for (i = 0; i < this.inputAtt; ++i) {
                for (j = 0; j < this.K; ++j) {
                    this.W[i][j] = this.trainOutput[instance] == this.trainOutput[nearestN[j]] ? this.V[i][j] : this.V[i][j] * -0.5;
                }
            }
            i = 0;
            while (i < this.inputAtt) {
                this.G[i] = 0.0;
                for (j = 0; j < this.K; ++j) {
                    int n = i;
                    this.G[n] = this.G[n] + this.W[i][j];
                }
                int n = i++;
                this.G[n] = this.G[n] / (double)this.K;
            }
            this.L = 0.0;
            for (int j2 = 0; j2 < this.K; ++j2) {
                module = 0.0;
                for (int i2 = 0; i2 < this.inputAtt; ++i2) {
                    module += this.W[i2][j2] * this.W[i2][j2];
                }
                this.L += Math.sqrt(module);
            }
            this.L /= (double)this.K;
            this.c2 = Math.sqrt(2.0) * this.gammaNextValue / this.gammaValue;
            this.c1 = this.c2 / (double)this.inputAtt;
            this.A[instance] = this.L / this.c2;
            module = 0.0;
            for (i = 0; i < this.inputAtt; ++i) {
                module += this.G[i] * this.G[i];
            }
            module = Math.sqrt(module);
            this.B[instance] = module / this.c1;
            for (i = 0; i < this.inputAtt; ++i) {
                this.TAU[instance][i] = this.G[i] / module;
            }
        }
    }

    @Override
    protected int evaluate(double[] example) {
        int i;
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (i = 0; i < this.K; ++i) {
            nearestN[i] = -1;
            minDist[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < this.trainData.length; ++i) {
            double dist = this.camDistance(example, i);
            if (!(dist > 0.0)) continue;
            boolean stop = false;
            for (int j = 0; j < this.K && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = this.K - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i;
                stop = true;
            }
        }
        int[] selectedClasses = new int[this.nClasses];
        for (i = 0; i < this.nClasses; ++i) {
            selectedClasses[i] = 0;
        }
        for (i = 0; i < this.K; ++i) {
            int n = this.trainOutput[nearestN[i]];
            selectedClasses[n] = selectedClasses[n] + 1;
        }
        int prediction = 0;
        int predictionValue = selectedClasses[0];
        for (i = 1; i < this.nClasses; ++i) {
            if (predictionValue >= selectedClasses[i]) continue;
            predictionValue = selectedClasses[i];
            prediction = i;
        }
        return prediction;
    }

    private double camDistance(double[] example, int instance) {
        double length = 0.0;
        length = this.euclideanDistance(example, this.trainData[instance]);
        double angleSum = 0.0;
        for (int i = 0; i < example.length; ++i) {
            angleSum += (example[i] - this.trainData[instance][i]) * this.TAU[instance][i];
        }
        double cosine = angleSum / length;
        double factor = this.A[instance];
        return length /= (factor += this.B[instance] * cosine);
    }

    private double fact(int n) {
        if (n < 2) {
            return 1.0;
        }
        int value = 1;
        for (int i = 2; i <= n; ++i) {
            value *= i;
        }
        return value;
    }

    private double doubleFact(int n) {
        if (n < 2) {
            return 1.0;
        }
        int value = 1;
        for (int i = n; i > 1; i -= 2) {
            value *= i;
        }
        return value;
    }
}

