/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD;

import java.io.IOException;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.Apriori;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.Population;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.RuleBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.myDataset;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.parseParameters;
import org.core.Files;
import org.core.Randomize;

public class Farchd {
    myDataset train;
    myDataset val;
    myDataset test;
    String outputTr;
    String outputTst;
    String fileDB;
    String fileRB;
    String fileTime;
    String fileHora;
    String data;
    String fileRules;
    String evolution;
    long rulesStage1;
    long rulesStage2;
    long rulesStage3;
    DataBase dataBase;
    RuleBase ruleBase;
    Apriori apriori;
    Population pop;
    long startTime;
    long totalTime;
    int nLabels;
    int populationSize;
    int depth;
    int K;
    int maxTrials;
    int typeInference;
    int BITS_GEN;
    double minsup;
    double minconf;
    double alpha;
    private boolean somethingWrong = false;

    public Farchd() {
    }

    public Farchd(parseParameters parameters) {
        this.startTime = System.currentTimeMillis();
        this.train = new myDataset();
        this.val = new myDataset();
        this.test = new myDataset();
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readClassificationSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readClassificationSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readClassificationSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.train.hasMissingAttributes();
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.fileDB = parameters.getOutputFile(0);
        this.fileRB = parameters.getOutputFile(1);
        this.data = parameters.getTrainingInputFile();
        this.fileTime = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/hora.txt";
        this.fileRules = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/rules.txt";
        long seed = Long.parseLong(parameters.getParameter(0));
        this.nLabels = Integer.parseInt(parameters.getParameter(1));
        this.minsup = Double.parseDouble(parameters.getParameter(2));
        this.minconf = Double.parseDouble(parameters.getParameter(3));
        this.depth = Integer.parseInt(parameters.getParameter(4));
        this.K = Integer.parseInt(parameters.getParameter(5));
        this.maxTrials = Integer.parseInt(parameters.getParameter(6));
        this.populationSize = Integer.parseInt(parameters.getParameter(7));
        if (this.populationSize % 2 > 0) {
            ++this.populationSize;
        }
        this.alpha = Double.parseDouble(parameters.getParameter(8));
        this.BITS_GEN = Integer.parseInt(parameters.getParameter(9));
        this.typeInference = Integer.parseInt(parameters.getParameter(10));
        Randomize.setSeed(seed);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, either the data-set has missing values.");
            System.err.println("Please remove the examples with missing data or apply a MV preprocessing.");
            System.err.println("Aborting the program");
        } else {
            this.dataBase = new DataBase(this.nLabels, this.train);
            this.ruleBase = new RuleBase(this.dataBase, this.train, this.K, this.typeInference);
            this.apriori = new Apriori(this.ruleBase, this.dataBase, this.train, this.minsup, this.minconf, this.depth);
            this.apriori.generateRB();
            this.rulesStage1 = this.apriori.getRulesStage1();
            this.rulesStage2 = this.ruleBase.size();
            this.pop = new Population(this.train, this.dataBase, this.ruleBase, this.populationSize, this.BITS_GEN, this.maxTrials, this.alpha);
            this.pop.Generation();
            System.out.println("Building classifier");
            this.ruleBase = this.pop.getBestRB();
            this.rulesStage3 = this.ruleBase.size();
            this.dataBase.saveFile(this.fileDB);
            this.ruleBase.saveFile(this.fileRB);
            this.doOutput(this.val, this.outputTr);
            this.doOutput(this.test, this.outputTst);
            this.totalTime = System.currentTimeMillis() - this.startTime;
            this.writeTime();
            this.writeRules();
            System.out.println("Algorithm Finished");
        }
    }

    public void writeRules() {
        String stringOut = new String("");
        stringOut = "" + this.rulesStage1 + " " + this.rulesStage2 + " " + this.rulesStage3 + "\n";
        Files.addToFile(this.fileRules, stringOut);
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.data + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.data + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void doOutput(myDataset dataset, String filename) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.getnData(); ++i) {
            output = output + dataset.getOutputAsString(i) + " " + this.classificationOutput(dataset.getExample(i)) + "\n";
        }
        Files.writeFile(filename, output);
    }

    private String classificationOutput(double[] example) {
        String output = new String("?");
        int clas = this.ruleBase.FRM(example);
        if (clas >= 0) {
            output = this.train.getOutputValue(clas);
        }
        return output;
    }
}

