/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Instance_Based_Learning.FuzzyNPC;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.FuzzyIBLAlgorithm;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.ReportTool;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Timer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Util;
import org.core.Files;

public class FuzzyNPC
extends FuzzyIBLAlgorithm {
    private static final double MAX_NORM = 1.0E8;
    private double M;
    private double[][] referenceMembership;
    private double[][] testMembership;
    private double[][] prototypes;

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.M = Double.parseDouble(tokens.nextToken().substring(1));
    }

    public FuzzyNPC(String script) {
        this.readDataFiles(script);
        this.name = "Fuzzy Nearest Prototype Classifier";
        this.referenceMembership = new double[this.referenceData.length][this.nClasses];
        this.testMembership = new double[this.testData.length][this.nClasses];
        ReportTool.setOutputFile(this.outFile[2]);
    }

    public void generateModel() {
        int j;
        int i;
        Timer.resetTime();
        this.prototypes = new double[this.nClasses][this.inputAtt];
        for (i = 0; i < this.nClasses; ++i) {
            Arrays.fill(this.prototypes[i], 0.0);
        }
        for (i = 0; i < this.trainData.length; ++i) {
            for (j = 0; j < this.trainData[0].length; ++j) {
                double[] dArray = this.prototypes[this.trainOutput[i]];
                int n = j;
                dArray[n] = dArray[n] + this.trainData[i][j];
            }
        }
        for (i = 0; i < this.nClasses; ++i) {
            for (j = 0; j < this.trainData[0].length; ++j) {
                if (this.nInstances[i] <= 0) continue;
                double[] dArray = this.prototypes[i];
                int n = j;
                dArray[n] = dArray[n] / (double)this.nInstances[i];
            }
        }
        Timer.setModelTime();
        System.out.println(this.name + " " + this.relation + " Model " + Timer.getModelTime() + "s");
    }

    public void classifyTrain() {
        Timer.resetTime();
        this.classifyTrainSet();
        Timer.setTrainingTime();
        System.out.println(this.name + " " + this.relation + " Training " + Timer.getTrainingTime() + "s");
    }

    public void classifyTest() {
        Timer.resetTime();
        this.classifyTestSet();
        Timer.setTestTime();
        System.out.println(this.name + " " + this.relation + " Test " + Timer.getTestTime() + "s");
    }

    public void classifyTrainSet() {
        for (int i = 0; i < this.trainData.length; ++i) {
            this.computeTrainMembership(i, this.referenceData[i]);
            this.trainPrediction[i] = this.computeClass(this.referenceMembership[i]);
        }
    }

    public void classifyTestSet() {
        for (int i = 0; i < this.testData.length; ++i) {
            this.computeTestMembership(i, this.testData[i]);
            this.testPrediction[i] = this.computeClass(this.testMembership[i]);
        }
    }

    private int computeClass(double[] pertenence) {
        double max = Double.MIN_VALUE;
        int output = -1;
        for (int i = 0; i < pertenence.length; ++i) {
            if (!(max < pertenence[i])) continue;
            max = pertenence[i];
            output = i;
        }
        return output;
    }

    private void computeTrainMembership(int index, double[] example) {
        int i;
        double[] norms = new double[this.nClasses];
        double sumNorm = 0.0;
        for (i = 0; i < this.nClasses; ++i) {
            if (this.nInstances[i] <= 0) continue;
            norms[i] = Util.euclideanDistance(this.prototypes[i], example);
            norms[i] = 1.0 / Math.pow(norms[i], 2.0 / (this.M - 1.0));
            norms[i] = Math.min(norms[i], 1.0E8);
            sumNorm += norms[i];
        }
        for (i = 0; i < this.nClasses; ++i) {
            this.referenceMembership[index][i] = this.nInstances[i] > 0 ? norms[i] / sumNorm : 0.0;
        }
    }

    private void computeTestMembership(int index, double[] example) {
        int i;
        double[] norms = new double[this.nClasses];
        double sumNorm = 0.0;
        for (i = 0; i < this.nClasses; ++i) {
            if (this.nInstances[i] <= 0) continue;
            norms[i] = Util.euclideanDistance(this.prototypes[i], example);
            norms[i] = 1.0 / Math.pow(norms[i], 2.0 / (this.M - 1.0));
            norms[i] = Math.min(norms[i], 1.0E8);
            sumNorm += norms[i];
        }
        for (i = 0; i < this.nClasses; ++i) {
            this.testMembership[index][i] = this.nInstances[i] > 0 ? norms[i] / sumNorm : 0.0;
        }
    }

    public void printReport() {
        this.writeOutput(this.outFile[0], this.trainOutput, this.trainPrediction);
        this.writeOutput(this.outFile[1], this.testOutput, this.testPrediction);
        ReportTool.setResults(this.trainOutput, this.trainPrediction, this.testOutput, this.testPrediction, this.nClasses);
        ReportTool.printReport();
    }
}

