/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.multivariate;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.multivariate.AbstractMultivariateSsf;

public abstract class DefaultMultivariateSsf
extends AbstractMultivariateSsf {
    int[] m_R;
    Matrix m_Z;
    DataBlock m_tmp;
    Matrix m_T;
    Matrix m_W;
    Matrix m_Pf0;
    Matrix m_B0;
    Matrix m_Q;

    @Override
    public void diffuseConstraints(SubMatrix b) {
        if (this.m_B0 != null) {
            b.copy(this.m_B0.subMatrix());
        }
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        Matrix WQW;
        if (!this.loadQ(pos, this.m_Q)) {
            return;
        }
        if (this.hasW()) {
            if (!this.loadW(pos, this.m_W)) {
                return;
            }
            WQW = SymmetricMatrix.quadraticFormT(this.m_Q, this.m_W);
        } else {
            WQW = this.m_Q;
        }
        if (this.hasR()) {
            if (this.loadR(pos, this.m_R)) {
                int nr = this.m_R.length;
                for (int i = 0; i < nr; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        qm.set(this.m_R[i], this.m_R[j], WQW.get(i, j));
                    }
                }
            }
        } else {
            qm.copy(WQW.subMatrix());
        }
    }

    @Override
    public int getVarsCount() {
        return this.m_Z == null ? 0 : this.m_Z.getRowsCount();
    }

    @Override
    public int getNonStationaryDim() {
        return this.m_B0 == null ? 0 : this.m_B0.getColumnsCount();
    }

    @Override
    public int getStateDim() {
        return this.m_Z == null ? 0 : this.m_Z.getColumnsCount();
    }

    @Override
    public int getTransitionResCount() {
        return this.m_R == null ? this.getStateDim() : this.m_R.length;
    }

    @Override
    public int getTransitionResDim() {
        return this.m_Q == null ? 0 : this.m_Q.getRowsCount();
    }

    @Override
    public boolean hasR() {
        return this.m_R != null;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public abstract boolean hasW();

    public void initialize(int dim, int vardim, int rescount, int resdim) {
        this.m_T = new Matrix(dim, dim);
        this.m_Z = new Matrix(vardim, dim);
        this.m_tmp = new DataBlock(dim);
        this.m_Q = new Matrix(resdim, resdim);
        if (rescount != dim) {
            this.m_R = new int[rescount];
        }
        if (rescount != resdim) {
            this.m_W = new Matrix(rescount, resdim);
        }
    }

    @Override
    public boolean isDiffuse() {
        return this.m_B0 != null;
    }

    @Override
    public abstract boolean isMeasurementEquationTimeInvariant();

    @Override
    public abstract boolean isTimeInvariant();

    @Override
    public abstract boolean isTransitionEquationTimeInvariant();

    @Override
    public abstract boolean isTransitionResidualTimeInvariant();

    @Override
    public boolean isValid() {
        if (this.m_Z == null || this.m_T == null || this.m_Q == null) {
            return false;
        }
        int r = this.m_Z.getColumnsCount();
        if (r != this.m_T.getColumnsCount() || r != this.m_T.getRowsCount()) {
            return false;
        }
        if (this.m_R != null && (this.m_W == null || this.m_R.length != this.m_W.getRowsCount())) {
            return false;
        }
        if (this.m_W != null && this.m_W.getColumnsCount() != this.m_Q.getRowsCount()) {
            return false;
        }
        if (this.m_Pf0 != null && this.m_Pf0.getRowsCount() != r) {
            return false;
        }
        return this.m_B0 == null || this.m_B0.getRowsCount() == r && this.m_B0.getColumnsCount() <= this.m_B0.getRowsCount();
    }

    @Override
    public void L(int pos, SubMatrix k, SubMatrix lm) {
        if (!this.loadT(pos, this.m_T) || !this.loadZ(pos, this.m_Z)) {
            return;
        }
        this.T(pos, lm);
        DataBlockIterator cols = lm.columns();
        DataBlock col = cols.getData();
        DataBlockIterator kcols = k.columns();
        DataBlock kcol = kcols.getData();
        do {
            kcols.begin();
            do {
                double z = -this.m_Z.get(kcols.getPosition(), cols.getPosition());
                col.addAY(z, kcol);
            } while (kcols.next());
        } while (cols.next());
    }

    protected abstract boolean loadQ(int var1, Matrix var2);

    protected abstract boolean loadR(int var1, int[] var2);

    protected abstract boolean loadT(int var1, Matrix var2);

    protected abstract boolean loadW(int var1, Matrix var2);

    protected abstract boolean loadZ(int var1, Matrix var2);

    @Override
    public void Pf0(SubMatrix pf0) {
        if (this.m_Pf0 != null) {
            pf0.copy(this.m_Pf0.subMatrix());
        }
    }

    @Override
    public void Pi0(SubMatrix pf0) {
        if (this.m_B0 != null) {
            pf0.copy(SymmetricMatrix.XXt(this.m_B0).subMatrix());
        }
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        if (!this.loadQ(pos, this.m_Q)) {
            return;
        }
        qm.copy(this.m_Q.subMatrix());
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        if (!this.loadR(pos, this.m_R)) {
            return;
        }
        rv.copy(SubArrayOfInt.create(this.m_R));
    }

    public void setB0(Matrix B0) {
        this.m_B0 = B0;
    }

    public void setPf0(Matrix pf0) {
        this.m_Pf0 = pf0;
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        if (!this.loadT(pos, this.m_T)) {
            return;
        }
        tr.copy(this.m_T.subMatrix());
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        if (!this.loadT(pos, this.m_T)) {
            return;
        }
        vm.copy(SymmetricMatrix.quadraticFormT(vm, this.m_T.subMatrix()).subMatrix());
    }

    @Override
    public void TX(int pos, DataBlock x) {
        if (!this.loadT(pos, this.m_T)) {
            return;
        }
        this.m_tmp.product(this.m_T.subMatrix().rows(), x);
        x.copy(this.m_tmp);
    }

    @Override
    public void VpZdZ(int pos, int v, int w, SubMatrix vm, double d) {
        if (!this.loadZ(pos, this.m_Z)) {
            return;
        }
        int n = this.m_Z.getColumnsCount();
        for (int r = 0; r < n; ++r) {
            double zr = this.m_Z.get(v, r);
            if (zr == 0.0) continue;
            zr *= d;
            for (int c = 0; c <= r; ++c) {
                double zc = this.m_Z.get(w, c);
                if (zc == 0.0) continue;
                double z = zr * zc;
                vm.add(r, c, z);
                if (r == c) continue;
                vm.add(c, r, z);
            }
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        if (!this.loadW(pos, this.m_W)) {
            return;
        }
        wv.copy(this.m_W.subMatrix());
    }

    @Override
    public void XpZd(int pos, int v, DataBlock x, double d) {
        if (!this.loadZ(pos, this.m_Z)) {
            return;
        }
        x.addAY(d, this.m_Z.row(v));
    }

    @Override
    public void XT(int pos, DataBlock x) {
        if (!this.loadT(pos, this.m_T)) {
            return;
        }
        this.m_tmp.product(x, this.m_T.subMatrix().columns());
        x.copy(this.m_tmp);
    }

    @Override
    public void Z(int pos, SubMatrix x) {
        if (!this.loadZ(pos, this.m_Z)) {
            return;
        }
        x.copy(this.m_Z.subMatrix());
    }

    @Override
    public void ZM(int pos, SubMatrix m, SubMatrix zm) {
        if (!this.loadZ(pos, this.m_Z)) {
            return;
        }
        zm.product(this.m_Z.subMatrix(), m);
    }

    @Override
    public void ZM(int pos, int v, SubMatrix m, DataBlock zm) {
        if (!this.loadZ(pos, this.m_Z)) {
            return;
        }
        zm.product(this.m_Z.row(v), m.columns());
    }

    @Override
    public void ZVZ(int pos, SubMatrix vm, SubMatrix zvz) {
        if (!this.loadZ(pos, this.m_Z)) {
            return;
        }
        SymmetricMatrix.quadraticFormT(vm, this.m_Z.subMatrix(), zvz);
    }

    @Override
    public void ZX(int pos, DataBlock x, DataBlock zx) {
        if (!this.loadZ(pos, this.m_Z)) {
            return;
        }
        zx.product(this.m_Z.rows(), x);
    }

    @Override
    public double ZX(int pos, int v, DataBlock x) {
        if (!this.loadZ(pos, this.m_Z)) {
            return 0.0;
        }
        return this.m_Z.row(v).dot(x);
    }

    @Override
    public void Z(int pos, int v, DataBlock z) {
        if (!this.loadZ(pos, this.m_Z)) {
            return;
        }
        z.copy(this.m_Z.row(v));
    }

    @Override
    public double ZVZ(int pos, int v, int w, SubMatrix vm) {
        if (!this.loadZ(pos, this.m_Z)) {
            return 0.0;
        }
        this.ZM(pos, v, vm, this.m_tmp);
        return this.m_tmp.dot(this.m_Z.row(w));
    }
}

