/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.benchmarking;

import ec.satoolkit.benchmarking.SaBenchmarkingSpec;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;

public class MultiSaBenchmarkingSpec
implements IProcSpecification,
Cloneable {
    public static final String ENABLED = "enabled";
    public static final String TARGET = "target";
    public static final String LAMBDA = "lambda";
    public static final String RHO = "rho";
    public static final String ANNUALCONSTRAINT = "tcnts";
    public static final String CONTEMPORANEOUSCONSTRAINT = "ccnts";
    public static double DEF_LAMBDA = 1.0;
    public static double DEF_RHO = 1.0;
    private boolean annualConstraints = false;
    private SaBenchmarkingSpec.Target target_ = SaBenchmarkingSpec.Target.Original;
    private double rho_ = DEF_RHO;
    private double lambda_ = DEF_LAMBDA;
    private ConstraintType contemporaneousConstraints = ConstraintType.Fixed;

    public boolean isEnabled() {
        return this.annualConstraints || this.contemporaneousConstraints != ConstraintType.None;
    }

    public SaBenchmarkingSpec.Target getTarget() {
        return this.target_;
    }

    public void setTarget(SaBenchmarkingSpec.Target target) {
        this.target_ = target;
    }

    public double getRho() {
        return this.rho_;
    }

    public void setRho(double rho) {
        this.rho_ = rho;
    }

    public double getLambda() {
        return this.lambda_;
    }

    public void setLambda(double lambda) {
        this.lambda_ = lambda;
    }

    public boolean isAnnualConstraint() {
        return this.annualConstraints;
    }

    public ConstraintType getContemporaneousConstraintType() {
        return this.contemporaneousConstraints;
    }

    public void setAnnualConstraint(boolean type) {
        this.annualConstraints = type;
    }

    public void setContemporaneousConstraintType(ConstraintType type) {
        this.contemporaneousConstraints = type;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && !this.isEnabled()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.target_ != SaBenchmarkingSpec.Target.Original) {
            info.add(TARGET, this.target_.name());
        }
        if (verbose || this.lambda_ != DEF_LAMBDA) {
            info.add(LAMBDA, Double.valueOf(this.lambda_));
        }
        if (verbose || this.rho_ != DEF_RHO) {
            info.add(RHO, Double.valueOf(this.rho_));
        }
        if (verbose || this.contemporaneousConstraints != ConstraintType.None) {
            info.add(CONTEMPORANEOUSCONSTRAINT, this.contemporaneousConstraints.name());
        }
        if (verbose || this.annualConstraints) {
            info.add(ANNUALCONSTRAINT, Boolean.valueOf(this.annualConstraints));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            String ccnt;
            Boolean tcnt;
            Double lambda;
            Double rho = info.get(RHO, Double.class);
            if (rho != null) {
                this.rho_ = rho;
            }
            if ((lambda = info.get(LAMBDA, Double.class)) != null) {
                this.lambda_ = lambda;
            }
            Boolean enabled = info.get(ENABLED, Boolean.class);
            String target = info.get(TARGET, String.class);
            if (target != null) {
                this.target_ = SaBenchmarkingSpec.Target.valueOf(target);
            }
            if ((tcnt = info.get(ANNUALCONSTRAINT, Boolean.class)) != null) {
                this.annualConstraints = tcnt;
            }
            if ((ccnt = info.get(CONTEMPORANEOUSCONSTRAINT, String.class)) != null) {
                this.contemporaneousConstraints = ConstraintType.valueOf(ccnt);
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    @Override
    public MultiSaBenchmarkingSpec clone() {
        try {
            return (MultiSaBenchmarkingSpec)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(MultiSaBenchmarkingSpec other) {
        return this.target_ == other.target_ && this.rho_ == other.rho_ && this.lambda_ == other.lambda_ && this.annualConstraints == other.annualConstraints && this.contemporaneousConstraints == other.contemporaneousConstraints;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof MultiSaBenchmarkingSpec && this.equals((MultiSaBenchmarkingSpec)obj);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.rho_) ^ Double.doubleToLongBits(this.rho_) >>> 32);
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.lambda_) ^ Double.doubleToLongBits(this.lambda_) >>> 32);
        return hash;
    }

    public static enum Target {
        Original,
        CalendarAdjusted;

    }

    public static enum ConstraintType {
        None,
        Fixed,
        Free;

    }
}

