/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static boolean containsAny(String str, char[] searchChars) {
        if (str == null || searchChars == null) {
            return false;
        }
        for (char ch : searchChars) {
            if (str.indexOf(ch) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String str, String searchChars) {
        return StringUtils.containsAny(str, searchChars.toCharArray());
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isWhitespace(String str) {
        return str != null && str.trim().length() == 0;
    }

    public static String readInputStream(InputStream is, String charset) throws IOException {
        int read;
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, charset);
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        return out.toString();
    }

    public static String readInputStream(InputStream is) throws IOException {
        return StringUtils.readInputStream(is, "UTF-8");
    }

    public static String join(Iterator<?> it, String separator) {
        if (!it.hasNext()) {
            return "";
        }
        Object obj = it.next();
        StringBuilder sb = new StringBuilder();
        if (obj == null) {
            sb.append("null");
        } else {
            sb.append(obj);
        }
        if (separator == null || separator.isEmpty()) {
            while (it.hasNext()) {
                obj = it.next();
                if (obj == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(obj);
            }
        } else {
            while (it.hasNext()) {
                obj = it.next();
                sb.append(separator);
                if (obj == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(obj);
            }
        }
        return sb.toString();
    }

    public static String join(Iterator<?> it, char separator) {
        return StringUtils.join(it, separator + "");
    }

    public static String join(Collection<?> coll, String separator) {
        return StringUtils.join(coll.iterator(), separator);
    }

    public static String join(Collection<?> coll, char separator) {
        return StringUtils.join(coll, separator + "");
    }

    public static String join(Object[] array, String separator) {
        return StringUtils.join(Arrays.asList(array).iterator(), separator);
    }

    public static String join(Object[] array, char separator) {
        return StringUtils.join(Arrays.asList(array).iterator(), separator);
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return null;
        }
        if (start < 0 && (start = str.length() + start) < 0) {
            return str;
        }
        if (start >= str.length()) {
            return "";
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = Math.max(str.length() + start, 0);
        }
        if (start >= str.length()) {
            return "";
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (end <= start) {
            return "";
        }
        return str.substring(start, end);
    }

    public static String getFileExtension(String filename) {
        String extension = "";
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            extension = filename.substring(i + 1).toLowerCase();
        }
        return extension;
    }

    public static String getFileExtension(File file) {
        return StringUtils.getFileExtension(file.getName());
    }
}

