/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import uk.ac.rhul.cs.cl1.ui.NodeSetTableModel;
import uk.ac.rhul.cs.cl1.ui.ResultViewerPanel;

public class ShowDetailedResultsAction
extends AbstractAction {
    protected ResultViewerPanel resultViewer;

    public ShowDetailedResultsAction(ResultViewerPanel panel) {
        this.resultViewer = panel;
        this.setIconURL(this.getDefaultIconURL());
        this.putValue("ShortDescription", "Shows or hides the details of each cluster");
    }

    public void actionPerformed(ActionEvent event) {
        NodeSetTableModel model = this.resultViewer.getTableModel();
        if (model.isInDetailedMode()) {
            model.setDetailedMode(false);
        } else {
            model.setDetailedMode(true);
        }
    }

    protected URL getDefaultIconURL() {
        return this.getClass().getResource("../resources/details.png");
    }

    public void setIconURL(URL url) {
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        } else {
            this.putValue("SmallIcon", null);
        }
    }
}

