/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import uk.ac.rhul.cs.cl1.CohesivenessFunction;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.QualityFunction;
import uk.ac.rhul.cs.cl1.ui.PValueRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSetDetails
implements Comparable<NodeSetDetails> {
    private static final NumberFormat fractionalFormat = new DecimalFormat("0.000");
    protected final NodeSet nodeSet;
    protected final QualityFunction qualityFunc = new CohesivenessFunction();
    protected String stringRep;

    public NodeSetDetails(NodeSet nodeSet) {
        this.nodeSet = nodeSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>Nodes: ");
        sb.append(this.nodeSet.size());
        sb.append("<br>");
        sb.append("Density: ");
        sb.append(fractionalFormat.format(this.nodeSet.getDensity()));
        sb.append("<br>");
        sb.append("Quality: ");
        sb.append(fractionalFormat.format(this.qualityFunc.calculate(this.nodeSet)));
        sb.append("<br>");
        double significance = this.nodeSet.getSignificance();
        sb.append("P-value: <font color=\"");
        sb.append(PValueRenderer.getColorCodeForValue(significance));
        sb.append("\">");
        sb.append(PValueRenderer.formatValue(significance, false));
        sb.append("</font>");
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public int compareTo(NodeSetDetails other) {
        double densityThat;
        int sizeThat;
        double sigThat;
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == other) {
            return 0;
        }
        if (this.nodeSet.equals(other.nodeSet)) {
            return 0;
        }
        double sigThis = this.nodeSet.getSignificance();
        if (sigThis < (sigThat = other.nodeSet.getSignificance())) {
            return 1;
        }
        if (sigThis > sigThat) {
            return -1;
        }
        double qThis = this.qualityFunc.calculate(this.nodeSet);
        double qThat = this.qualityFunc.calculate(other.nodeSet);
        int sizeThis = this.nodeSet.size();
        if (qThis * (double)sizeThis > qThat * (double)(sizeThat = other.nodeSet.size())) {
            return 1;
        }
        if (qThis * (double)sizeThis < qThat * (double)sizeThat) {
            return -1;
        }
        double densityThis = this.nodeSet.getDensity();
        if (densityThis > (densityThat = other.nodeSet.getDensity())) {
            return 1;
        }
        if (densityThis < densityThat) {
            return -1;
        }
        return this.nodeSet.hashCode() - other.nodeSet.hashCode();
    }
}

