/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.seeding;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.seeding.SeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.SeedIterator;
import uk.ac.rhul.cs.graph.BronKerboschMaximalCliqueFinder;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.utils.BlockingQueueAdapter;

public class MaximalCliqueSeedGenerator
extends SeedGenerator {
    public MaximalCliqueSeedGenerator() {
    }

    public MaximalCliqueSeedGenerator(Graph graph) {
        super(graph);
    }

    public int size() {
        return -1;
    }

    public SeedIterator iterator() {
        return new IteratorImpl();
    }

    class IteratorImpl
    extends SeedIterator {
        BronKerboschMaximalCliqueFinder cliqueFinder;
        ArrayBlockingQueue<List<Integer>> cliques = new ArrayBlockingQueue(100);
        Thread cliqueFinderThread = null;

        public IteratorImpl() {
            this.cliqueFinder = new BronKerboschMaximalCliqueFinder();
            this.cliqueFinder.setGraph(MaximalCliqueSeedGenerator.this.graph);
            this.cliqueFinderThread = new Thread(new Runnable(){

                public void run() {
                    BlockingQueueAdapter<List<Integer>> cliqueCollection = new BlockingQueueAdapter<List<Integer>>(IteratorImpl.this.cliques);
                    IteratorImpl.this.cliqueFinder.getMaximalCliques(cliqueCollection);
                }
            });
            this.cliqueFinderThread.start();
        }

        public boolean hasNext() {
            if (this.cliques.isEmpty()) {
                return this.cliqueFinderThread.isAlive() && !this.cliqueFinderThread.isInterrupted();
            }
            return true;
        }

        public MutableNodeSet next() {
            try {
                return new MutableNodeSet(MaximalCliqueSeedGenerator.this.graph, (Collection<Integer>)this.cliques.take());
            }
            catch (InterruptedException ex) {
                return null;
            }
        }
    }
}

