/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.util.Vector;
import org.rosuda.ibase.MapSegmentEntry;
import org.rosuda.util.Tools;

public class MapSegment {
    public double minX;
    public double minY;
    public double maxX;
    public double maxY;
    Vector ents = new Vector();
    boolean isFirst = true;

    public void add(double[] xpt, double[] ypt) {
        MapSegmentEntry mse = new MapSegmentEntry(xpt, ypt, false, true);
        this.add(mse);
    }

    public void add(double[] xpt, double[] ypt, boolean isLake) {
        MapSegmentEntry mse = new MapSegmentEntry(xpt, ypt, isLake, true);
        this.add(mse);
    }

    public void add(double[] xpt, double[] ypt, int offset, int length, boolean isLake) {
        MapSegmentEntry mse = new MapSegmentEntry(xpt, ypt, offset, length, isLake, true);
        this.add(mse);
    }

    public void add(MapSegmentEntry mse) {
        this.ents.addElement(mse);
        if (mse != null) {
            if (this.isFirst) {
                this.minX = mse.minX;
                this.maxX = mse.maxX;
                this.minY = mse.minY;
                this.maxY = mse.maxY;
                this.isFirst = false;
            } else {
                if (mse.minX < this.minX) {
                    this.minX = mse.minX;
                }
                if (mse.minY < this.minY) {
                    this.minY = mse.minY;
                }
                if (mse.maxX > this.maxX) {
                    this.maxX = mse.maxX;
                }
                if (mse.maxY > this.maxY) {
                    this.maxY = mse.maxY;
                }
            }
        }
    }

    public int count() {
        return this.ents.size();
    }

    public MapSegmentEntry at(int i) {
        return (MapSegmentEntry)this.ents.elementAt(i);
    }

    public int getSizeAt(int i) {
        MapSegmentEntry mse = (MapSegmentEntry)this.ents.elementAt(i);
        return mse == null ? 0 : mse.xp.length;
    }

    public double[] getXat(int i) {
        MapSegmentEntry mse = (MapSegmentEntry)this.ents.elementAt(i);
        return mse == null ? null : mse.xp;
    }

    public double[] getYat(int i) {
        MapSegmentEntry mse = (MapSegmentEntry)this.ents.elementAt(i);
        return mse == null ? null : mse.yp;
    }

    public boolean isLakeAt(int i) {
        MapSegmentEntry mse = (MapSegmentEntry)this.ents.elementAt(i);
        return mse != null && mse.isLake;
    }

    public int[] getXtransAt(int id, double scale, double off, int poff) {
        MapSegmentEntry mse = (MapSegmentEntry)this.ents.elementAt(id);
        if (mse == null) {
            return null;
        }
        int[] xs = new int[mse.xp.length];
        for (int i = 0; i < mse.xp.length; ++i) {
            xs[i] = poff + (int)((mse.xp[i] + off) * scale);
        }
        return xs;
    }

    public int[] getYtransAt(int id, double scale, double off, int poff) {
        MapSegmentEntry mse = (MapSegmentEntry)this.ents.elementAt(id);
        if (mse == null) {
            return null;
        }
        int[] ys = new int[mse.yp.length];
        for (int i = 0; i < mse.yp.length; ++i) {
            ys[i] = poff + (int)((mse.yp[i] + off) * scale);
        }
        return ys;
    }

    public String toString() {
        return "Map segment (" + Tools.getDisplayableValue(this.minX) + "," + Tools.getDisplayableValue(this.minY) + ")-(" + Tools.getDisplayableValue(this.maxX) + "," + Tools.getDisplayableValue(this.maxY) + ")";
    }
}

