/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.Arrays;
import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleSorting;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;

class TestGenericSorting {
    protected TestGenericSorting() {
    }

    public static void demo1() {
        final int[] nArray = new int[]{3, 2, 1};
        final double[] dArray = new double[]{3.0, 2.0, 1.0};
        final double[] dArray2 = new double[]{6.0, 7.0, 8.0};
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
                double d = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d;
                double d2 = dArray2[n];
                dArray2[n] = dArray2[n2];
                dArray2[n2] = d2;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return nArray[n] == nArray[n2] ? 0 : (nArray[n] < nArray[n2] ? -1 : 1);
            }
        };
        System.out.println("before:");
        System.out.println("X=" + Arrays.toString(nArray));
        System.out.println("Y=" + Arrays.toString(dArray));
        System.out.println("Z=" + Arrays.toString(dArray2));
        int n = 0;
        int n2 = nArray.length;
        GenericSorting.quickSort(n, n2, intComparator, swapper);
        System.out.println("after:");
        System.out.println("X=" + Arrays.toString(nArray));
        System.out.println("Y=" + Arrays.toString(dArray));
        System.out.println("Z=" + Arrays.toString(dArray2));
        System.out.println("\n\n");
    }

    public static void demo2() {
        final int[] nArray = new int[]{6, 7, 8, 9};
        final double[] dArray = new double[]{3.0, 2.0, 1.0, 3.0};
        final double[] dArray2 = new double[]{5.0, 4.0, 4.0, 1.0};
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
                double d = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d;
                double d2 = dArray2[n];
                dArray2[n] = dArray2[n2];
                dArray2[n2] = d2;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                if (dArray[n] == dArray[n2]) {
                    return dArray2[n] == dArray2[n2] ? 0 : (dArray2[n] < dArray2[n2] ? -1 : 1);
                }
                return dArray[n] < dArray[n2] ? -1 : 1;
            }
        };
        System.out.println("before:");
        System.out.println("X=" + Arrays.toString(nArray));
        System.out.println("Y=" + Arrays.toString(dArray));
        System.out.println("Z=" + Arrays.toString(dArray2));
        int n = 0;
        int n2 = nArray.length;
        GenericSorting.quickSort(n, n2, intComparator, swapper);
        System.out.println("after:");
        System.out.println("X=" + Arrays.toString(nArray));
        System.out.println("Y=" + Arrays.toString(dArray));
        System.out.println("Z=" + Arrays.toString(dArray2));
        System.out.println("\n\n");
    }

    public static void testRandomly(int n) {
        DoubleMersenneTwister doubleMersenneTwister = new DoubleMersenneTwister();
        DoubleUniform doubleUniform = new DoubleUniform(doubleMersenneTwister);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = 50;
            int n5 = doubleUniform.nextIntFromTo(1, n4);
            if (n5 == 0) {
                n3 = 0;
                n2 = -1;
            } else {
                n3 = doubleUniform.nextIntFromTo(0, n5 - 1);
                n2 = doubleUniform.nextIntFromTo(Math.min(n3, n5 - 1), n5 - 1);
            }
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n5, n5);
            DoubleMatrix2D doubleMatrix2D = denseDoubleMatrix2D.viewPart(n3, n3, n5 - n2, n5 - n2);
            int n6 = doubleUniform.nextIntFromTo(n5 / 2, 2 * n5);
            int n7 = doubleUniform.nextIntFromTo(n6, 2 * n5);
            for (int j = 0; j < n5; ++j) {
                for (int k = 0; k < n5; ++k) {
                    denseDoubleMatrix2D.set(j, k, doubleUniform.nextIntFromTo(n6, n7));
                }
            }
            DoubleMatrix2D doubleMatrix2D2 = denseDoubleMatrix2D.copy();
            DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D2.viewPart(n3, n3, n5 - n2, n5 - n2);
            int n8 = 0;
            DoubleMatrix2D doubleMatrix2D4 = DoubleSorting.quickSort.sort(doubleMatrix2D, n8);
            DoubleMatrix2D doubleMatrix2D5 = DoubleSorting.mergeSort.sort(doubleMatrix2D3, n8);
            if (doubleMatrix2D4.viewColumn(n8).equals(doubleMatrix2D5.viewColumn(n8))) continue;
            throw new InternalError();
        }
        System.out.println("All tests passed. No bug detected.");
    }

    public static void main(String[] stringArray) {
        TestGenericSorting.demo1();
        TestGenericSorting.demo2();
        TestGenericSorting.testRandomly(2);
    }
}

