/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.rosuda.deducer.menu.CorModel;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class CorOptions
extends JDialog
implements ActionListener {
    private JPanel alternativePanel;
    private JRadioButton twoSided;
    private JRadioButton greater;
    private JTextField confLevel;
    private JSeparator sep;
    private JCheckBox n;
    private JCheckBox pValue;
    private JCheckBox stat;
    private JCheckBox ci;
    private ButtonGroup alternative;
    private JPanel navPanel;
    private JTextField digits;
    private JLabel digitLabel;
    private JPanel outputPanel;
    private JCheckBox print;
    private JLabel percLabel;
    private JLabel ConfidenceLabel;
    private JRadioButton lessThan;
    private CorModel.OptModel model;

    public CorOptions(JDialog jDialog, CorModel.OptModel optModel) {
        super(jDialog);
        this.initGUI();
        this.setModel(optModel);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.alternativePanel = new JPanel();
            this.getContentPane().add(this.alternativePanel);
            this.alternativePanel.setLayout(null);
            this.alternativePanel.setBounds(49, 12, 202, 99);
            this.alternativePanel.setBorder(BorderFactory.createTitledBorder("Alternative"));
            this.twoSided = new JRadioButton();
            this.alternativePanel.add(this.twoSided);
            this.twoSided.setText("Two-sided");
            this.twoSided.setBounds(17, 20, 180, 19);
            this.lessThan = new JRadioButton();
            this.alternativePanel.add(this.lessThan);
            this.lessThan.setText("Less");
            this.lessThan.setBounds(17, 45, 180, 19);
            this.greater = new JRadioButton();
            this.alternativePanel.add(this.greater);
            this.greater.setText("Greater");
            this.greater.setBounds(17, 70, 168, 19);
            this.ConfidenceLabel = new JLabel();
            this.getContentPane().add(this.ConfidenceLabel);
            this.ConfidenceLabel.setText("Confidence Level:");
            this.ConfidenceLabel.setBounds(58, 123, 120, 15);
            this.confLevel = new JTextField();
            this.getContentPane().add(this.confLevel);
            this.confLevel.setText("95");
            this.confLevel.setBounds(178, 119, 46, 22);
            this.percLabel = new JLabel();
            this.getContentPane().add(this.percLabel);
            this.percLabel.setText("%");
            this.percLabel.setBounds(230, 123, 17, 15);
            this.navPanel = new OkayCancelPanel(false, false, this);
            this.navPanel.setBounds(83, 284, 206, 55);
            this.getContentPane().add(this.navPanel);
            this.outputPanel = new JPanel();
            this.getContentPane().add(this.outputPanel);
            this.outputPanel.setLayout(null);
            this.outputPanel.setBounds(12, 150, 277, 117);
            this.outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
            this.print = new JCheckBox();
            this.outputPanel.add(this.print);
            this.print.setText("Print Matrix");
            this.print.setBounds(17, 20, 154, 19);
            this.digitLabel = new JLabel();
            this.outputPanel.add(this.digitLabel);
            this.digitLabel.setText("Digits:");
            this.digitLabel.setBounds(17, 80, 44, 15);
            this.digits = new JTextField();
            this.outputPanel.add(this.digits);
            this.digits.setText("<auto>");
            this.digits.setBounds(67, 76, 68, 22);
            this.ci = new JCheckBox();
            this.outputPanel.add(this.ci);
            this.ci.setText("CI");
            this.ci.setBounds(82, 39, 39, 19);
            this.stat = new JCheckBox();
            this.outputPanel.add(this.stat);
            this.stat.setText("Stat");
            this.stat.setBounds(127, 39, 53, 19);
            this.pValue = new JCheckBox();
            this.outputPanel.add(this.pValue);
            this.pValue.setText("p-value");
            this.pValue.setBounds(186, 39, 86, 19);
            this.n = new JCheckBox();
            this.outputPanel.add(this.n);
            this.n.setText("N");
            this.n.setBounds(37, 39, 39, 19);
            this.sep = new JSeparator();
            this.outputPanel.add(this.sep);
            this.sep.setBounds(37, 64, 167, 10);
            this.alternative = new ButtonGroup();
            this.alternative.add(this.twoSided);
            this.alternative.add(this.lessThan);
            this.alternative.add(this.greater);
            this.setTitle("Test Options");
            this.setResizable(false);
            this.setSize(301, 373);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModel(CorModel.OptModel optModel) {
        this.model = optModel;
        if (this.model.alternative == "two.sided") {
            this.twoSided.setSelected(true);
        } else if (this.model.alternative == "less") {
            this.lessThan.setSelected(true);
        } else {
            this.greater.setSelected(true);
        }
        this.confLevel.setText(Double.toString(this.model.confLevel * 100.0));
        this.digits.setText(this.model.digits);
        this.print.setSelected(this.model.showTable);
        this.n.setSelected(this.model.n);
        this.ci.setSelected(this.model.ci);
        this.stat.setSelected(this.model.stat);
        this.pValue.setSelected(this.model.pValue);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "OK") {
            double d;
            try {
                d = Double.parseDouble(this.confLevel.getText());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Confidence Level: Please enter a number between 0 and 100");
                return;
            }
            if (d < 0.0 || d > 100.0) {
                JOptionPane.showMessageDialog(this, "Confidence Level: Please enter a number between 0 and 100");
                return;
            }
            String string2 = this.digits.getText();
            int n = 0;
            if (!string2.equals("<auto>")) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Digits: Please enter a number.");
                    return;
                }
                if (n < 1) {
                    JOptionPane.showMessageDialog(this, "Digits: Please enter a positive integer.");
                    return;
                }
            }
            this.model.confLevel = d / 100.0;
            this.model.digits = string2;
            this.model.showTable = this.print.isSelected();
            this.model.n = this.n.isSelected();
            this.model.stat = this.stat.isSelected();
            this.model.pValue = this.pValue.isSelected();
            this.model.ci = this.ci.isSelected();
            this.model.alternative = this.twoSided.isSelected() ? "two.sided" : (this.lessThan.isSelected() ? "less" : "greater");
            this.dispose();
        }
        if (string == "Cancel") {
            this.dispose();
        }
    }
}

