/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.preorder.ContinuousExtensionDelegate;
import dr.evomodel.treedatalikelihood.preorder.ModelExtensionProvider;
import dr.inference.model.CrossValidationProvider;
import dr.inference.model.Parameter;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;
import dr.xml.Reportable;
import java.util.ArrayList;

public class TraitValidationProvider
implements CrossValidationProvider,
Reportable {
    private final Parameter trueTraits;
    private final int[] missingInds;
    private final String[] dimNames;
    private final String sumName;
    private final int dimTrait;
    private final ContinuousExtensionDelegate extensionDelegate;

    public TraitValidationProvider(Parameter parameter, ContinuousTraitPartialsProvider continuousTraitPartialsProvider, Tree tree, String string, Parameter parameter2, TreeDataLikelihood treeDataLikelihood, String string2, boolean[] blArray) {
        this.trueTraits = parameter;
        this.dimTrait = continuousTraitPartialsProvider.getDataDimension();
        this.missingInds = this.setupMissingInds(continuousTraitPartialsProvider, parameter2, blArray);
        int n = this.missingInds.length;
        TreeTrait treeTrait = treeDataLikelihood.getTreeTrait("tip." + string2);
        this.extensionDelegate = continuousTraitPartialsProvider instanceof ModelExtensionProvider ? ((ModelExtensionProvider)continuousTraitPartialsProvider).getExtensionDelegate((ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate(), treeTrait, tree) : new ContinuousExtensionDelegate((ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate(), treeTrait, tree);
        this.dimNames = new String[n];
        this.setupDimNames(tree, string);
        this.sumName = this.getSumName(string);
    }

    private int[] setupMissingInds(ContinuousTraitPartialsProvider continuousTraitPartialsProvider, Parameter parameter, boolean[] blArray) {
        int[] nArray;
        int n = 0;
        if (parameter == null) {
            int n2;
            boolean[] blArray2 = continuousTraitPartialsProvider.getDataMissingIndicators();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < blArray2.length; ++n2) {
                if (!blArray2[n2] || blArray[n2]) continue;
                arrayList.add(n2);
            }
            n = arrayList.size();
            nArray = new int[n];
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = (Integer)arrayList.get(n2);
            }
        } else {
            int n3;
            for (n3 = 0; n3 < parameter.getSize(); ++n3) {
                if (parameter.getParameterValue(n3) != 1.0 || blArray[n3]) continue;
                ++n;
            }
            nArray = new int[n];
            n3 = 0;
            for (int i = 0; i < parameter.getSize(); ++i) {
                if (parameter.getParameterValue(i) != 1.0 || blArray[i]) continue;
                nArray[n3] = i;
                ++n3;
            }
        }
        return nArray;
    }

    private String getId(String string) {
        if (string == null) {
            return "traitValidationProvider";
        }
        return string;
    }

    private void setupDimNames(Tree tree, String string) {
        string = this.getId(string);
        int n = 0;
        for (int n2 : this.missingInds) {
            int n3 = n2 / this.dimTrait;
            int n4 = n2 - n3 * this.dimTrait;
            String string2 = tree.getTaxonId(n3);
            this.dimNames[n] = string + "." + string2 + "." + (n4 + 1);
            ++n;
        }
    }

    private String getSumName(String string) {
        string = this.getId(string);
        return string + ".TotalSum";
    }

    @Override
    public double[] getTrueValues() {
        return this.trueTraits.getParameterValues();
    }

    @Override
    public double[] getInferredValues() {
        return this.extensionDelegate.getExtendedValues();
    }

    @Override
    public int[] getRelevantDimensions() {
        return this.missingInds;
    }

    @Override
    public String getName(int n) {
        return this.dimNames[n];
    }

    @Override
    public String getNameSum(int n) {
        return this.sumName;
    }

    @Override
    public String getReport() {
        int n;
        int n2 = 1000000;
        int n3 = this.missingInds.length;
        double[] dArray = new double[n3];
        double[][] dArray2 = new double[n3][n3];
        for (n = 0; n < n2; ++n) {
            double[] dArray3 = this.extensionDelegate.getExtendedValues();
            for (int i = 0; i < n3; ++i) {
                double d = dArray3[this.missingInds[i]];
                int n4 = i;
                dArray[n4] = dArray[n4] + d;
                double[] dArray4 = dArray2[i];
                int n5 = i;
                dArray4[n5] = dArray4[n5] + d * d;
                int n6 = 0;
                while (n6 < i) {
                    double d2 = dArray3[this.missingInds[n6]];
                    double[] dArray5 = dArray2[i];
                    int n7 = n6++;
                    dArray5[n7] = dArray5[n7] + d * d2;
                }
            }
        }
        for (n = 0; n < n3; ++n) {
            dArray[n] = dArray[n] / (double)n2;
            dArray2[n][n] = dArray2[n][n] / (double)n2 - dArray[n] * dArray[n];
            for (int i = 0; i < n; ++i) {
                dArray2[n][i] = dArray2[n][i] / (double)n2 - dArray[n] * dArray[i];
                dArray2[i][n] = dArray2[n][i];
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Mean:\t");
        stringBuilder.append(new Vector(dArray));
        stringBuilder.append("\n");
        stringBuilder.append("Covariance:\t");
        stringBuilder.append(new Matrix(dArray2));
        return stringBuilder.toString();
    }
}

