/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Logger;

public class RandomTaxaSampleParser
extends AbstractXMLObjectParser {
    public static final String RANDOM_TAXA_SAMPLE = "randomTaxaSample";
    public static final String SAMPLE = "sample";
    public static final String PRINT_TAXA = "printTaxa";
    public static final String FILE_NAME = "fileName";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("sample"), new ElementRule(Taxa.class)};

    @Override
    public String getParserDescription() {
        return "Randomly samples n taxa from a collection of N taxa";
    }

    @Override
    public Class getReturnType() {
        return RandomTaxaSampleParser.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Comparable<Taxon> comparable;
        int n;
        int n2;
        Taxa taxa = (Taxa)xMLObject.getChild(Taxa.class);
        int n3 = xMLObject.getIntegerAttribute(SAMPLE);
        int n4 = taxa.getTaxonCount();
        if (n3 <= 0 || n3 > n4) {
            throw new XMLParseException("sample must be greater than 0 and less than or equal to the population size");
        }
        Taxa taxa2 = new Taxa();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            arrayList.add(n2);
        }
        Logger.getLogger("dr.evolution").info("Generating a random taxa sample of size: " + n3);
        for (n2 = 0; n2 < n3; ++n2) {
            n = MathUtils.nextInt(arrayList.size());
            comparable = taxa.getTaxon((Integer)arrayList.get(n));
            taxa2.addTaxon((Taxon)comparable);
            arrayList.remove(n);
        }
        if (xMLObject.hasAttribute(PRINT_TAXA) && xMLObject.getBooleanAttribute(PRINT_TAXA)) {
            String string = null;
            if (xMLObject.hasAttribute(FILE_NAME)) {
                string = xMLObject.getStringAttribute(FILE_NAME);
            }
            if (string != null) {
                try {
                    comparable = new File(string);
                    String string2 = ((File)comparable).getName();
                    String string3 = ((File)comparable).getParent();
                    if (!((File)comparable).isAbsolute()) {
                        string3 = System.getProperty("user.dir");
                    }
                    FileWriter fileWriter = new FileWriter(new File(string3, string2));
                    fileWriter.write("<taxa id=\"randomTaxaSample\">\n");
                    for (int i = 0; i < n3; ++i) {
                        fileWriter.write("\t<taxon idref=\"" + taxa2.getTaxonId(i) + "\"/>\n");
                    }
                    fileWriter.write("</taxa id=\"randomTaxaSample\">\n");
                    ((Writer)fileWriter).flush();
                }
                catch (IOException iOException) {
                    throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
                }
            } else {
                Logger.getLogger("dr.evomodel").info("<taxa id=\"randomTaxaSample\">");
                for (n = 0; n < n3; ++n) {
                    Logger.getLogger("dr.evomodel").info("\t<taxon idref=\" " + taxa2.getTaxonId(n) + " \"> ");
                }
                Logger.getLogger("dr.evomodel").info("</taxa id=\"randomTaxaSample\">");
            }
        }
        return taxa2;
    }

    @Override
    public String getParserName() {
        return RANDOM_TAXA_SAMPLE;
    }
}

