/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evomodel.substmodel.FrequencyModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import java.util.List;

public class ProductChainFrequencyModel
extends FrequencyModel {
    private List<FrequencyModel> freqModels;
    private final int numBaseModel;
    private final int totalFreqCount;
    private final int[] stateSizes;
    private final int[] tmp;

    public ProductChainFrequencyModel(String string, List<FrequencyModel> list) {
        super(string);
        this.freqModels = list;
        int n = 1;
        this.numBaseModel = list.size();
        this.stateSizes = new int[this.numBaseModel];
        for (int i = 0; i < this.numBaseModel; ++i) {
            int n2;
            this.stateSizes[i] = n2 = list.get(i).getFrequencyCount();
            n *= n2;
            this.addModel(list.get(i));
        }
        this.tmp = new int[this.numBaseModel];
        this.totalFreqCount = n;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged(model);
    }

    @Override
    public void setFrequency(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double getFrequency(int n) {
        double d = 1.0;
        this.decomposeEntry(n, this.tmp);
        for (int i = 0; i < this.numBaseModel; ++i) {
            d *= this.freqModels.get(i).getFrequency(this.tmp[i]);
        }
        return d;
    }

    public int[] decomposeEntry(int n) {
        int[] nArray = new int[this.numBaseModel];
        this.decomposeEntry(n, nArray);
        return nArray;
    }

    private void decomposeEntry(int n, int[] nArray) {
        int n2 = n;
        for (int i = this.numBaseModel - 1; i >= 0; --i) {
            nArray[i] = n2 % this.stateSizes[i];
            n2 /= this.stateSizes[i];
        }
    }

    @Override
    public int getFrequencyCount() {
        return this.totalFreqCount;
    }

    @Override
    public Parameter getFrequencyParameter() {
        throw new RuntimeException("Not implemented");
    }
}

