/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExponentialGrowth;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodelxml.coalescent.demographicmodel.ExponentialGrowthModelParser;
import dr.inference.model.Parameter;

public class ExponentialGrowthModel
extends DemographicModel {
    Parameter N0Parameter = null;
    Parameter growthRateParameter = null;
    ExponentialGrowth exponentialGrowth = null;
    boolean usingGrowthRate = true;

    public ExponentialGrowthModel(Parameter parameter, Parameter parameter2, Units.Type type, boolean bl) {
        this(ExponentialGrowthModelParser.EXPONENTIAL_GROWTH_MODEL, parameter, parameter2, type, bl);
    }

    public ExponentialGrowthModel(String string, Parameter parameter, Parameter parameter2, Units.Type type, boolean bl) {
        super(string);
        this.exponentialGrowth = new ExponentialGrowth(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.growthRateParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.usingGrowthRate = bl;
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.exponentialGrowth.setN0(this.N0Parameter.getParameterValue(0));
        if (this.usingGrowthRate) {
            double d = this.growthRateParameter.getParameterValue(0);
            this.exponentialGrowth.setGrowthRate(d);
        } else {
            double d = this.growthRateParameter.getParameterValue(0);
            this.exponentialGrowth.setDoublingTime(d);
        }
        return this.exponentialGrowth;
    }
}

