/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.evomodel.tree.randomlocalmodel.RandomLocalTreeVariable;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class RandomLocalClockModel
extends AbstractBranchRateModel
implements RandomLocalTreeVariable,
Citable {
    private double scaleFactor;
    private TreeModel treeModel;
    private boolean ratesAreMultipliers;
    private double[] unscaledBranchRates;
    private Parameter meanRateParameter;
    private TreeParameterModel indicators;
    private TreeParameterModel rates;
    private boolean recalculationNeeded = true;
    private final double threshold;
    public static Citation CITATION = new Citation(new Author[]{new Author("AJ", "Drummond"), new Author("MA", "Suchard")}, "Bayesian random local clocks, or one rate to rule them all", 2010, "BMC Biology", "8: 114", "10.1186/1741-7007-8-114");

    public RandomLocalClockModel(TreeModel treeModel, Parameter parameter, Parameter parameter2, Parameter parameter3, boolean bl, double d) {
        super("randomLocalClockModel");
        int n;
        this.ratesAreMultipliers = bl;
        this.indicators = new TreeParameterModel(treeModel, parameter2, false);
        this.rates = new TreeParameterModel(treeModel, parameter3, false);
        if (Double.isNaN(d)) {
            parameter2.addBounds(new Parameter.DefaultBounds(1.0, 0.0, parameter2.getDimension()));
            this.threshold = 0.5;
            for (n = 0; n < parameter2.getDimension(); ++n) {
                parameter2.setParameterValue(n, 0.0);
            }
        } else {
            parameter2.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, -1.7976931348623157E308, parameter2.getDimension()));
            this.threshold = d;
        }
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter3.getDimension()));
        for (n = 0; n < parameter2.getDimension(); ++n) {
            parameter3.setParameterValue(n, 1.0);
        }
        this.meanRateParameter = parameter;
        this.addModel(treeModel);
        this.treeModel = treeModel;
        this.addModel(this.indicators);
        this.addModel(this.rates);
        if (parameter != null) {
            this.addVariable(parameter);
        }
        this.unscaledBranchRates = new double[treeModel.getNodeCount()];
        Logger.getLogger("dr.evomodel").info("  indicator parameter name is '" + parameter2.getId() + "' with threshold = " + d);
        this.recalculateScaleFactor();
    }

    @Override
    public final double getVariable(Tree tree, NodeRef nodeRef) {
        return this.rates.getNodeValue(tree, nodeRef);
    }

    @Override
    public final boolean isVariableSelected(Tree tree, NodeRef nodeRef) {
        return this.indicators.getNodeValue(tree, nodeRef) > this.threshold;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        this.recalculationNeeded = true;
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.recalculationNeeded = true;
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.recalculationNeeded = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        if (this.recalculationNeeded) {
            this.recalculateScaleFactor();
            this.recalculationNeeded = false;
        }
        return this.unscaledBranchRates[nodeRef.getNumber()] * this.scaleFactor;
    }

    private void calculateUnscaledBranchRates(TreeModel treeModel) {
        this.recursivelyCompute(treeModel, treeModel.getRoot(), 1.0);
    }

    private void recursivelyCompute(TreeModel treeModel, NodeRef nodeRef, double d) {
        int n = nodeRef.getNumber();
        if (!treeModel.isRoot(nodeRef) && this.isVariableSelected(treeModel, nodeRef)) {
            d = this.ratesAreMultipliers ? (d *= this.getVariable(treeModel, nodeRef)) : this.getVariable(treeModel, nodeRef);
        }
        this.unscaledBranchRates[n] = d;
        int n2 = treeModel.getChildCount(nodeRef);
        for (int i = 0; i < n2; ++i) {
            this.recursivelyCompute(treeModel, treeModel.getChild(nodeRef, i), d);
        }
    }

    private void recalculateScaleFactor() {
        this.calculateUnscaledBranchRates(this.treeModel);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getNode(i);
            if (this.treeModel.isRoot(nodeRef)) continue;
            double d3 = this.treeModel.getNodeHeight(this.treeModel.getParent(nodeRef)) - this.treeModel.getNodeHeight(nodeRef);
            double d4 = d3 * this.unscaledBranchRates[nodeRef.getNumber()];
            d += d3;
            d2 += d4;
        }
        this.scaleFactor = d / d2;
        if (this.meanRateParameter != null) {
            this.scaleFactor *= this.meanRateParameter.getParameterValue(0);
        }
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.MOLECULAR_CLOCK;
    }

    @Override
    public String getDescription() {
        return "Local clock model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

