## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(BayesMallows)

## -----------------------------------------------------------------------------
library(parallel)
cl <- makeCluster(2)
fit <- compute_mallows(
  rankings = potato_visual, nmc = 5000,
  cl = cl
)
stopCluster(cl)

## -----------------------------------------------------------------------------
assess_convergence(fit)

## -----------------------------------------------------------------------------
assess_convergence(fit, parameter = "rho", items = 1:3)

## -----------------------------------------------------------------------------
fit$burnin <- 700

## -----------------------------------------------------------------------------
plot(fit)

## -----------------------------------------------------------------------------
plot(fit, parameter = "rho", items = 4:7)

## -----------------------------------------------------------------------------
beach_tc <- generate_transitive_closure(beach_preferences)

## -----------------------------------------------------------------------------
cl <- makeCluster(2)
fit <- compute_mallows(
  preferences = beach_tc, nmc = 4000,
  alpha_init = runif(2, 1, 4),
  save_aug = TRUE, cl = cl
)
stopCluster(cl)

## -----------------------------------------------------------------------------
assess_convergence(fit)

## -----------------------------------------------------------------------------
assess_convergence(fit, parameter = "rho", items = 4:6)

## -----------------------------------------------------------------------------
assess_convergence(fit,
  parameter = "Rtilde",
  items = 1:3, assessors = 1:2
)

## -----------------------------------------------------------------------------
fit$burnin <- 700

## -----------------------------------------------------------------------------
plot(fit)

## -----------------------------------------------------------------------------
plot(fit, parameter = "rho", items = 6:9)

## -----------------------------------------------------------------------------
compute_posterior_intervals(fit, parameter = "alpha")

## -----------------------------------------------------------------------------
compute_posterior_intervals(fit, parameter = "rho")

## -----------------------------------------------------------------------------
compute_consensus(fit)

## -----------------------------------------------------------------------------
compute_consensus(fit, type = "MAP")

## -----------------------------------------------------------------------------
plot_top_k(fit, k = 4)

