/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.checkpoint.SentinelCheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.proxies.MetricsCollectingKinesisProxyDecorator;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class KinesisDataFetcher {
    private static final Log LOG = LogFactory.getLog(KinesisDataFetcher.class);
    private String nextIterator;
    private IKinesisProxy kinesisProxy;
    private final String shardId;
    private boolean isShardEndReached;
    private boolean isInitialized;

    public KinesisDataFetcher(IKinesisProxy kinesisProxy, ShardInfo shardInfo) {
        this.shardId = shardInfo.getShardId();
        this.kinesisProxy = new MetricsCollectingKinesisProxyDecorator("KinesisDataFetcher", kinesisProxy, this.shardId);
    }

    public GetRecordsResult getRecords(int maxRecords) {
        if (!this.isInitialized) {
            throw new IllegalArgumentException("KinesisDataFetcher.getRecords called before initialization.");
        }
        GetRecordsResult response = null;
        if (this.nextIterator != null) {
            try {
                response = this.kinesisProxy.get(this.nextIterator, maxRecords);
                this.nextIterator = response.getNextShardIterator();
            }
            catch (ResourceNotFoundException e) {
                LOG.info((Object)("Caught ResourceNotFoundException when fetching records for shard " + this.shardId));
                this.nextIterator = null;
            }
            if (this.nextIterator == null) {
                this.isShardEndReached = true;
            }
        } else {
            this.isShardEndReached = true;
        }
        return response;
    }

    public void initialize(String initialCheckpoint, InitialPositionInStreamExtended initialPositionInStream) {
        LOG.info((Object)("Initializing shard " + this.shardId + " with " + initialCheckpoint));
        this.advanceIteratorTo(initialCheckpoint, initialPositionInStream);
        this.isInitialized = true;
    }

    public void initialize(ExtendedSequenceNumber initialCheckpoint, InitialPositionInStreamExtended initialPositionInStream) {
        LOG.info((Object)("Initializing shard " + this.shardId + " with " + initialCheckpoint.getSequenceNumber()));
        this.advanceIteratorTo(initialCheckpoint.getSequenceNumber(), initialPositionInStream);
        this.isInitialized = true;
    }

    void advanceIteratorTo(String sequenceNumber, InitialPositionInStreamExtended initialPositionInStream) {
        if (sequenceNumber == null) {
            throw new IllegalArgumentException("SequenceNumber should not be null: shardId " + this.shardId);
        }
        this.nextIterator = sequenceNumber.equals(SentinelCheckpoint.LATEST.toString()) ? this.getIterator(ShardIteratorType.LATEST.toString()) : (sequenceNumber.equals(SentinelCheckpoint.TRIM_HORIZON.toString()) ? this.getIterator(ShardIteratorType.TRIM_HORIZON.toString()) : (sequenceNumber.equals(SentinelCheckpoint.AT_TIMESTAMP.toString()) ? this.getIterator(initialPositionInStream.getTimestamp()) : (sequenceNumber.equals(SentinelCheckpoint.SHARD_END.toString()) ? null : this.getIterator(ShardIteratorType.AT_SEQUENCE_NUMBER.toString(), sequenceNumber))));
        if (this.nextIterator == null) {
            this.isShardEndReached = true;
        }
    }

    private String getIterator(String iteratorType, String sequenceNumber) {
        String iterator = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Calling getIterator for " + this.shardId + ", iterator type " + iteratorType + " and sequence number " + sequenceNumber));
            }
            iterator = this.kinesisProxy.getIterator(this.shardId, iteratorType, sequenceNumber);
        }
        catch (ResourceNotFoundException e) {
            LOG.info((Object)("Caught ResourceNotFoundException when getting an iterator for shard " + this.shardId), (Throwable)e);
        }
        return iterator;
    }

    private String getIterator(String iteratorType) {
        String iterator = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Calling getIterator for " + this.shardId + " and iterator type " + iteratorType));
            }
            iterator = this.kinesisProxy.getIterator(this.shardId, iteratorType);
        }
        catch (ResourceNotFoundException e) {
            LOG.info((Object)("Caught ResourceNotFoundException when getting an iterator for shard " + this.shardId), (Throwable)e);
        }
        return iterator;
    }

    private String getIterator(Date timestamp) {
        String iterator = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Calling getIterator for " + this.shardId + " and timestamp " + timestamp));
            }
            iterator = this.kinesisProxy.getIterator(this.shardId, timestamp);
        }
        catch (ResourceNotFoundException e) {
            LOG.info((Object)("Caught ResourceNotFoundException when getting an iterator for shard " + this.shardId), (Throwable)e);
        }
        return iterator;
    }

    protected boolean isShardEndReached() {
        return this.isShardEndReached;
    }

    String getNextIterator() {
        return this.nextIterator;
    }
}

