## ---- include = FALSE---------------------------------------------------------
library(triact)

## -----------------------------------------------------------------------------
options(digits.secs = 3)

## -----------------------------------------------------------------------------
options(triact_table = "data.frame")

## -----------------------------------------------------------------------------
?Triact

## -----------------------------------------------------------------------------
dir <-  system.file("extdata", package = "triact") 

files <- list.files(dir)

print(files)

## -----------------------------------------------------------------------------
cat(paste(readLines(file.path(dir, files[1]), n = 30), collapse = "\n"))

## -----------------------------------------------------------------------------
my_triact <- Triact$new()

## -----------------------------------------------------------------------------
my_triact$load_files(input = dir,
                     id_substring = c(1, 5),
                     timeFwdUpRight_cols = c(1, 2 ,3, 4),
                     skip = "*DATA")

## -----------------------------------------------------------------------------
head(my_triact$data)

## -----------------------------------------------------------------------------
str(my_triact$data)

## -----------------------------------------------------------------------------
my_triact$add_lying()

## -----------------------------------------------------------------------------
my_triact$add_side(left_leg = TRUE)

## -----------------------------------------------------------------------------
my_triact$add_activity()

## -----------------------------------------------------------------------------
str(my_triact$data)

## -----------------------------------------------------------------------------
cow_id = "cow01"

data_013 <- my_triact$data[my_triact$data$id == cow_id, ]

plot(!lying ~ time, data = data_013,
     type = "l", ylab = "", yaxt = "n", bty = "n")

lines(ifelse(side == "R", 0, NA) ~ time, data = data_013, col = "orange")
lines(ifelse(side == "L", 0, NA) ~ time, data = data_013, col = "purple")

axis(2, at = c(0, 1),
     labels = c("lying", "standing"),
     las = 1,
     lwd = 0)

legend(x = "center",
       legend = c("right", "left"),
       col = c("orange", "purple"),
       lwd = 1, bty = "n", title = "lying side")

## -----------------------------------------------------------------------------
bouts_summary <- my_triact$summarize_bouts()

## -----------------------------------------------------------------------------
head(bouts_summary)

## -----------------------------------------------------------------------------
bouts_summary <- my_triact$summarize_bouts(bout_type = "lying")

## -----------------------------------------------------------------------------
head(bouts_summary)

## -----------------------------------------------------------------------------
int_summary <- my_triact$summarize_intervals()

## -----------------------------------------------------------------------------
head(int_summary)

## -----------------------------------------------------------------------------
str(int_summary)

## -----------------------------------------------------------------------------
int_summary <- my_triact$summarize_intervals(interval = "30 min",
                                             lag_in_s = 10 * 60)

## -----------------------------------------------------------------------------
head(int_summary)

## -----------------------------------------------------------------------------
str(int_summary)

## -----------------------------------------------------------------------------
int_summary <- my_triact$summarize_intervals(bouts = TRUE,
                                             side = TRUE)

## -----------------------------------------------------------------------------
str(int_summary)

## -----------------------------------------------------------------------------
st_ups <- my_triact$extract_standup()

## -----------------------------------------------------------------------------
print(st_ups)

## -----------------------------------------------------------------------------
l_downs <- my_triact$extract_liedown(sec_before = 3, sec_after = 3)

## -----------------------------------------------------------------------------
head(l_downs[[1]])

