/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.shallot.parameter.decay;

import org.apache.commons.math3.util.FastMath;
import org.ddahl.shallot.parameter.decay.DecayFunction;
import org.ddahl.shallot.parameter.decay.SubtractionDecayFactory;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Q2A\u0001C\u0005\u0001)!Aq\u0004\u0001BC\u0002\u0013\u0005\u0001\u0005\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\"\u0011!)\u0003A!b\u0001\n\u0003\u0001\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\t\u000b\u001d\u0002A\u0011\u0001\u0015\t\u000b1\u0002A\u0011A\u0017\t\u000bA\u0002A\u0011A\u0019\u0003!M+(\r\u001e:bGRLwN\u001c#fG\u0006L(B\u0001\u0006\f\u0003\u0015!WmY1z\u0015\taQ\"A\u0005qCJ\fW.\u001a;fe*\u0011abD\u0001\bg\"\fG\u000e\\8u\u0015\t\u0001\u0012#A\u0003eI\u0006DGNC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\r\u0001Qc\u0007\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qiR\"A\u0005\n\u0005yI!!\u0004#fG\u0006Lh)\u001e8di&|g.A\u0006uK6\u0004XM]1ukJ,W#A\u0011\u0011\u0005Y\u0011\u0013BA\u0012\u0018\u0005\u0019!u.\u001e2mK\u0006aA/Z7qKJ\fG/\u001e:fA\u0005AQ.\u0019=WC2,X-A\u0005nCb4\u0016\r\\;fA\u00051A(\u001b8jiz\"2!\u000b\u0016,!\ta\u0002\u0001C\u0003 \u000b\u0001\u0007\u0011\u0005C\u0003&\u000b\u0001\u0007\u0011%A\u0003baBd\u0017\u0010\u0006\u0002\"]!)qF\u0002a\u0001C\u0005\t\u00010\u0001\u0004va\u0012\fG/\u001a\u000b\u0003SIBQaM\u0004A\u0002\u0005\nA\u0001^3na\u0002")
public class SubtractionDecay
implements DecayFunction {
    private final double temperature;
    private final double maxValue;

    @Override
    public double temperature() {
        return this.temperature;
    }

    public double maxValue() {
        return this.maxValue;
    }

    @Override
    public double apply(double x) {
        return FastMath.pow((double)(this.maxValue() - x), (double)this.temperature());
    }

    @Override
    public SubtractionDecay update(double temp) {
        return new SubtractionDecayFactory(this.maxValue()).apply(temp);
    }

    public SubtractionDecay(double temperature, double maxValue) {
        this.temperature = temperature;
        this.maxValue = maxValue;
        DecayFunction.$init$(this);
    }
}

