/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.analysis.causality;

import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.OntologyConstants;
import org.vikamine.kernel.data.RDFStatement;
import org.vikamine.kernel.data.RDFTripleStore;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.analysis.causality.CausalACausalSGNode;
import org.vikamine.kernel.subgroup.analysis.causality.CausalSGNode;
import org.vikamine.kernel.subgroup.analysis.causality.NonCausalSGNode;
import org.vikamine.kernel.subgroup.analysis.causality.TargetSGNode;

public class CausalSGNodeFactory {
    private static CausalSGNodeFactory instance = new CausalSGNodeFactory();

    private CausalSGNodeFactory() {
    }

    public static CausalSGNodeFactory getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Instance should have been eagerly created!");
        }
        return instance;
    }

    public static boolean isACausalSubgroup(SG sg, Ontology onto) {
        if (onto == null) {
            return false;
        }
        RDFTripleStore store = onto.getTripleStore();
        RDFStatement firstMatchingStatement = store.getFirstMatchingStatement(sg, OntologyConstants.ACAUSAL_SUBGROUP, "**ANY_OBJECT**");
        if (firstMatchingStatement == null) {
            return false;
        }
        return (Boolean)firstMatchingStatement.getObject();
    }

    public CausalSGNode createCausalSGNode(SG sg, Ontology onto) {
        if (CausalSGNodeFactory.isACausalSubgroup(sg, onto)) {
            return new CausalACausalSGNode(sg);
        }
        return new CausalSGNode(sg);
    }

    public CausalSGNode createTargetSGNode(SG targetSG) {
        return new TargetSGNode(targetSG);
    }

    public CausalSGNode createNonCausalSGNode(SG sg) {
        return new NonCausalSGNode(sg);
    }
}

