/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.vikamine.kernel.data.DerivedAttributeBuilder;
import org.vikamine.kernel.data.DerivedNominalAttribute;
import org.vikamine.kernel.data.DerivedNominalValue;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.formula.FormulaNumber;
import org.vikamine.kernel.formula.constants.FormulaAttributePrimitive;
import org.vikamine.kernel.formula.operators.EqualsNumber;

public class DerivedNominalAttributeBuilder
extends DerivedAttributeBuilder {
    private final NumericAttribute na;
    private final Ontology om;

    public DerivedNominalAttributeBuilder(NumericAttribute na, Ontology om) {
        this.na = na;
        this.om = om;
    }

    public void buildNominalCustomAttribute() {
        List<Value> values = this.buildValues();
        String name = String.valueOf(this.na.getId()) + "_nominalized";
        this.attribute = new DerivedNominalAttribute(name, values);
        this.attribute.setDescription(name);
        for (Value v : values) {
            ((DerivedNominalValue)v).setAttribute(this.attribute);
        }
    }

    private List<Value> buildValues() {
        ArrayList<Value> result = new ArrayList<Value>();
        Iterator<Value> iter = this.na.usedValuesIterator(this.om.getDataset());
        int i = 0;
        while (iter.hasNext()) {
            String num = iter.next().toString();
            DerivedNominalValue value = new DerivedNominalValue("Value" + i, num);
            FormulaNumber formNum1 = new FormulaNumber(Double.parseDouble(num));
            EqualsNumber eq = new EqualsNumber();
            eq.setArg1(new FormulaAttributePrimitive(this.na));
            eq.setArg2(formNum1);
            value.setCondition(eq);
            result.add(value);
            ++i;
        }
        return result;
    }
}

