/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.MathUtils;

public class PropDivXYZ
extends Propagator<IntVar> {
    private final IntVar X;
    private final IntVar Y;
    private final IntVar Z;
    private final IntVar absX;
    private final IntVar absY;
    private final IntVar absZ;

    public PropDivXYZ(IntVar x, IntVar y, IntVar z) {
        this(x, y, z, x.getModel().intAbsView(x), x.getModel().intAbsView(y), x.getModel().intAbsView(z));
    }

    private PropDivXYZ(IntVar x, IntVar y, IntVar z, IntVar ax, IntVar ay, IntVar az) {
        super((Variable[])new IntVar[]{x, y, z, ax, ay, az}, (Priority)PropagatorPriority.TERNARY, false);
        this.X = x;
        this.Y = y;
        this.Z = z;
        this.absX = ax;
        this.absY = ay;
        this.absZ = az;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        boolean hasChanged;
        do {
            int mask = 0;
            mask += this.X.isInstantiated() ? 1 : 0;
            mask += this.Y.isInstantiated() ? 2 : 0;
            mask += this.Z.isInstantiated() ? 4 : 0;
            hasChanged = this.Y.removeValue(0, (ICause)this);
            if (this.outInterval(this.Y, 0, 0)) {
                return;
            }
            switch (mask) {
                case 0: {
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsY();
                    hasChanged |= this.updateAbsZ();
                    break;
                }
                case 1: {
                    hasChanged |= this.updateAbsY();
                    hasChanged |= this.updateAbsZ();
                    if (!this.X.isInstantiatedTo(0)) break;
                    hasChanged |= this.Z.instantiateTo(0, (ICause)this);
                    break;
                }
                case 2: {
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsZ();
                    break;
                }
                case 3: {
                    int vx = this.X.getValue();
                    int vy = this.Y.getValue();
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsY();
                    int vz = vx / vy;
                    if (!this.inInterval(this.Z, vz, vz)) break;
                    return;
                }
                case 4: {
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsY();
                    if (!this.Z.isInstantiatedTo(0) || this.X.contains(0)) break;
                    hasChanged |= this.absX.updateUpperBound(this.absY.getUB() - 1, (ICause)this);
                    break;
                }
                case 5: {
                    int vx = this.X.getValue();
                    int vz = this.Z.getValue();
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsZ();
                    if (vz != 0 && vx == 0) {
                        this.fails();
                    }
                    hasChanged |= this.updateAbsY();
                    break;
                }
                case 6: {
                    int vy = this.Y.getValue();
                    int vz = this.Z.getValue();
                    hasChanged |= this.updateAbsY();
                    hasChanged |= this.updateAbsZ();
                    if (vz == 0) {
                        if (!this.inInterval(this.X, -Math.abs(vy) + 1, Math.abs(vy) - 1)) break;
                        return;
                    }
                    hasChanged |= this.updateAbsX();
                    break;
                }
                case 7: {
                    int vx = this.X.getValue();
                    int vy = this.Y.getValue();
                    int vz = this.Z.getValue();
                    int val = vx / vy;
                    if (vz != val) {
                        this.fails();
                        break;
                    }
                    return;
                }
                default: {
                    throw new SolverException("Unexpected mask " + mask);
                }
            }
            if (this.absX.getUB() < this.absY.getLB()) {
                hasChanged |= this.Z.instantiateTo(0, (ICause)this);
                continue;
            }
            if (this.X.getLB() > 0 && this.absX.getLB() >= this.absY.getUB()) {
                hasChanged |= this.sameSign(this.Z, this.Y);
                hasChanged |= this.sameSign(this.Y, this.Z);
                continue;
            }
            if (this.X.getUB() >= 0 || this.absX.getLB() < this.absY.getUB()) continue;
            hasChanged |= this.oppSign(this.Z, this.Y);
            hasChanged |= this.oppSign(this.Y, this.Z);
        } while (hasChanged);
    }

    @Override
    public ESat isEntailed() {
        boolean neg;
        boolean pos;
        if (this.Y.isInstantiatedTo(0)) {
            return ESat.FALSE;
        }
        if (this.X.isInstantiatedTo(0) && !this.Z.contains(0)) {
            return ESat.FALSE;
        }
        boolean bl = pos = this.X.getLB() >= 0 && this.Y.getLB() >= 0 || this.X.getUB() < 0 && this.Y.getUB() < 0;
        if (pos && this.Z.getUB() < 0) {
            return ESat.FALSE;
        }
        boolean bl2 = neg = this.X.getLB() >= 0 && this.Y.getUB() < 0 || this.X.getUB() < 0 && this.Y.getLB() >= 0;
        if (neg && this.Z.getLB() > 0) {
            return ESat.FALSE;
        }
        int minAbsX = this.X.getLB() > 0 ? this.X.getLB() : (this.X.getUB() < 0 ? -this.X.getUB() : 0);
        int maxAbsX = Math.max(this.X.getUB(), -this.X.getLB());
        int minAbsY = this.Y.getLB() > 0 ? this.Y.getLB() : (this.Y.getUB() < 0 ? -this.Y.getUB() : 1);
        int maxAbsY = Math.max(this.Y.getUB(), -this.Y.getLB());
        int minAbsZ = this.Z.getLB() > 0 ? this.Z.getLB() : (this.Z.getUB() < 0 ? -this.Z.getUB() : 0);
        int maxAbsZ = Math.max(this.Z.getUB(), -this.Z.getLB());
        if (minAbsZ > maxAbsX / minAbsY || maxAbsZ < minAbsX / maxAbsY) {
            return ESat.FALSE;
        }
        if (this.Z.isInstantiatedTo(0) && minAbsX > maxAbsY || maxAbsX < minAbsY && !this.Z.contains(0)) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(this.X.getValue() / this.Y.getValue() == this.Z.getValue());
        }
        return ESat.UNDEFINED;
    }

    private boolean inInterval(IntVar v, int lb, int ub) throws ContradictionException {
        if (v.getLB() >= lb && v.getUB() <= ub) {
            this.setPassive();
            return true;
        }
        if (v.getLB() <= ub && v.getUB() >= lb) {
            v.updateBounds(lb, ub, this);
            this.setPassive();
            return true;
        }
        this.fails();
        return false;
    }

    private boolean outInterval(IntVar v, int lb, int ub) throws ContradictionException {
        if (lb > ub) {
            this.setPassive();
            return true;
        }
        if (lb < ub) {
            if (v.getLB() > ub || v.getUB() < lb) {
                this.setPassive();
                return true;
            }
            if (v.getLB() >= lb && v.getUB() <= ub) {
                this.fails();
            } else {
                if (v.getLB() >= lb) {
                    v.updateLowerBound(ub + 1, (ICause)this);
                } else if (v.getUB() <= ub) {
                    v.updateUpperBound(lb - 1, (ICause)this);
                }
                this.setPassive();
                return true;
            }
        }
        return false;
    }

    private boolean updateAbsX() throws ContradictionException {
        return this.absX.updateLowerBound(MathUtils.safeMultiply(this.absZ.getLB(), this.absY.getLB()), (ICause)this) | this.absX.updateUpperBound(MathUtils.safeAdd(MathUtils.safeMultiply(this.absZ.getUB(), this.absY.getUB()), this.absY.getUB() - 1), (ICause)this);
    }

    private boolean updateAbsY() throws ContradictionException {
        int yub;
        boolean res = this.absZ.getLB() != 0 && this.absY.updateUpperBound((int)Math.floor(this.absX.getUB() / this.absZ.getLB()), (ICause)this);
        int zlb = this.absZ.getLB();
        int zub = this.absZ.getUB();
        int xlb = this.absX.getLB();
        int num = xlb - ((yub = this.absY.getUB()) - 1);
        res = num >= 0 && zub != 0 ? (res |= this.absY.updateLowerBound((int)Math.ceil(num / zub), (ICause)this)) : (res |= zlb != 0 && this.absY.updateLowerBound(-((int)Math.floor((-xlb + (yub - 1)) / zlb)), (ICause)this));
        return res;
    }

    private boolean updateAbsZ() throws ContradictionException {
        boolean res = this.absY.getLB() != 0 && this.absZ.updateUpperBound((int)Math.floor(this.absX.getUB() / this.absY.getLB()), (ICause)this);
        int xlb = this.absX.getLB();
        int ylb = this.absY.getLB();
        int yub = this.absY.getUB();
        int num = xlb - (yub - 1);
        res = num >= 0 && yub != 0 ? (res |= this.absZ.updateLowerBound((int)Math.ceil(num / yub), (ICause)this)) : (res |= ylb != 0 && this.absZ.updateLowerBound(-((int)Math.floor((-xlb + (yub - 1)) / ylb)), (ICause)this));
        return res;
    }

    protected boolean sameSign(IntVar a2, IntVar b) throws ContradictionException {
        boolean res = false;
        if (b.getLB() >= 0) {
            res = a2.updateLowerBound(0, (ICause)this);
        }
        if (b.getUB() <= 0) {
            res |= a2.updateUpperBound(0, (ICause)this);
        }
        if (!b.contains(0)) {
            res |= a2.removeValue(0, (ICause)this);
        }
        return res;
    }

    protected boolean oppSign(IntVar a2, IntVar b) throws ContradictionException {
        boolean res = false;
        if (b.getLB() >= 0) {
            res = a2.updateUpperBound(0, (ICause)this);
        }
        if (b.getUB() <= 0) {
            res |= a2.updateLowerBound(0, (ICause)this);
        }
        if (b.contains(0)) {
            res |= a2.removeValue(0, (ICause)this);
        }
        return res;
    }
}

