/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.clauses;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.learn.XParameters;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.view.bool.BoolEqView;
import org.chocosolver.solver.variables.view.bool.BoolLeqView;
import org.chocosolver.solver.variables.view.bool.BoolNotView;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;
import org.chocosolver.util.tools.VariableUtils;

public class ClauseBuilder {
    private static final short ALWAYSTRUE = 2;
    private static final short UNKNOWN = 1;
    private static final short FALSE = 0;
    private final Set<IntVar> vars = new HashSet<IntVar>();
    private final TIntObjectHashMap<IntIterableRangeSet> sets = new TIntObjectHashMap();
    private short status = 0;
    private final TIntObjectHashMap<IntIterableRangeSet> initialDomains = new TIntObjectHashMap();

    public ClauseBuilder(Model mModel) {
        Arrays.stream(mModel.retrieveIntVars(true)).forEach(v -> this.initialDomains.put(v.getId(), new IntIterableRangeSet((IntVar)v)));
    }

    public ClauseBuilder put(IntVar var, IntIterableRangeSet set) {
        this.status = (short)(this.status | 1);
        if (var.isAConstant()) {
            if (!set.contains(var.getValue())) {
                this.status = (short)(this.status | 2);
            }
            return this;
        }
        if (set.intersect(this.initialDomains.get(var.getId()))) {
            if (IntIterableSetUtils.includedIn(this.initialDomains.get(var.getId()), set)) {
                this.status = (short)(this.status | 2);
            }
            this.vars.add(var);
            this.sets.put(var.getId(), set);
        }
        return this;
    }

    public void buildNogood(Model model) {
        block8: {
            block9: {
                if ((this.status & 2) != 0) break block8;
                if ((this.status & 1) == 0) break block9;
                if (XParameters.ELIMINATE_VIEWS) {
                    this.eliminateViews();
                }
                this.vars.removeIf(var -> this.sets.get(var.getId()).isEmpty());
                Object[] _vars = this.vars.toArray(new IntVar[0]);
                Arrays.sort(_vars);
                switch (this.vars.size()) {
                    case 0: {
                        model.falseConstraint().post();
                        if (XParameters.PRINT_CLAUSE) {
                            model.getSolver().log().white().printf("learn: FALSE\n", new Object[0]);
                            break;
                        }
                        break block8;
                    }
                    case 1: {
                        model.member((IntVar)_vars[0], this.sets.get(_vars[0].getId())).post();
                        if (XParameters.PRINT_CLAUSE) {
                            model.getSolver().log().white().printf("learn: %s \u2208 %s\n", _vars[0], this.sets.get(_vars[0].getId()));
                            break;
                        }
                        break block8;
                    }
                    default: {
                        IntIterableRangeSet[] ranges = new IntIterableRangeSet[_vars.length];
                        for (int i = 0; i < _vars.length; ++i) {
                            ranges[i] = this.sets.get(_vars[i].getId());
                        }
                        model.getClauseConstraint().addClause((IntVar[])_vars, ranges);
                        break;
                    }
                }
                break block8;
            }
            model.falseConstraint().post();
            throw new UnsupportedOperationException();
        }
        this.status = 0;
        this.vars.clear();
        this.sets.clear();
    }

    private void eliminateViews() {
        Stack keys = this.vars.stream().filter(VariableUtils::isView).collect(Stack::new, Stack::push, Vector::addAll);
        while (!keys.isEmpty()) {
            IntVar v = (IntVar)keys.pop();
            if (v instanceof BoolEqView) {
                this.eliminateEqView((BoolEqView)v, keys);
                continue;
            }
            if (v instanceof BoolLeqView) {
                this.eliminateLeqView((BoolLeqView)v, keys);
                continue;
            }
            if (!(v instanceof BoolNotView)) continue;
            this.eliminateNotView((BoolNotView)v, keys);
        }
    }

    private void eliminateEqView(BoolEqView ev, Stack<IntVar> keys) {
        IntIterableRangeSet set = this.sets.get(ev.getId());
        assert (set.size() == 1);
        assert (set.min() >= 0 && set.max() <= 1);
        Object vv = ev.getVariable();
        if (set.min() == 1) {
            if (this.vars.contains(vv)) {
                this.sets.get(vv.getId()).add(ev.cste);
            } else {
                this.put((IntVar)vv, new IntIterableRangeSet(ev.cste));
                if (VariableUtils.isView(vv)) {
                    keys.push((IntVar)vv);
                }
            }
        } else if (set.min() == 0) {
            IntIterableRangeSet es = this.initialDomains.get(vv.getId()).duplicate();
            es.remove(ev.cste);
            if (this.vars.contains(vv)) {
                this.sets.get(vv.getId()).addAll(es);
            } else {
                this.put((IntVar)vv, es);
                if (VariableUtils.isView(vv)) {
                    keys.push((IntVar)vv);
                }
            }
        }
        set.clear();
    }

    private void eliminateLeqView(BoolLeqView lv, Stack<IntVar> keys) {
        IntIterableRangeSet set = this.sets.get(lv.getId());
        assert (set.size() == 1);
        assert (set.min() >= 0 && set.max() <= 1);
        Object vv = lv.getVariable();
        IntIterableRangeSet root = this.initialDomains.get(vv.getId()).duplicate();
        if (set.min() == 1) {
            root.retainBetween(-1073741823, lv.cste);
        } else if (set.min() == 0) {
            root.removeBetween(-1073741823, lv.cste);
        }
        if (this.vars.contains(vv)) {
            this.sets.get(vv.getId()).addAll(root);
        } else {
            this.put((IntVar)vv, root);
            if (VariableUtils.isView(vv)) {
                keys.push((IntVar)vv);
            }
        }
        set.clear();
    }

    private void eliminateNotView(BoolNotView nv, Stack<IntVar> keys) {
        IntIterableRangeSet set = this.sets.get(nv.getId());
        BoolVar vv = nv.not();
        assert (set.size() == 1);
        int value = set.min();
        if (this.vars.contains(vv)) {
            this.sets.get(vv.getId()).add(1 - value);
        } else {
            this.put(vv, new IntIterableRangeSet(1 - value));
            if (VariableUtils.isView(vv)) {
                keys.push(vv);
            }
        }
        set.clear();
    }

    public IntIterableRangeSet getInitialDomain(IntVar var) {
        return this.initialDomains.get(var.getId());
    }
}

