/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.choco;

import java.util.stream.IntStream;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.restopt.choco.ConnectivityFinderSpatialGraph;
import org.restopt.choco.SmallestEnclosingCircle;

public class LandscapeIndicesUtils {
    public static double effectiveMeshSize(UndirectedGraph g, int landscapeArea) {
        ConnectivityFinderSpatialGraph connFinder = new ConnectivityFinderSpatialGraph(g);
        connFinder.findAllCC();
        double mesh = 0.0;
        for (int i = 0; i < connFinder.getNBCC(); ++i) {
            int s = connFinder.getSizeCC()[i];
            mesh += 1.0 * (double)s * (double)s;
        }
        return mesh /= 1.0 * (double)landscapeArea;
    }

    public static double[] getSmallestEnclosingCircle(double[][] coordinates) {
        int[] points = IntStream.range(0, coordinates.length).toArray();
        if (points.length == 0) {
            return new double[0];
        }
        SmallestEnclosingCircle minidisk = new SmallestEnclosingCircle(points, coordinates);
        return new double[]{minidisk.centerY, minidisk.centerY, minidisk.radius};
    }

    public static final double distance(double[] p1, double[] p2) {
        return Math.sqrt(Math.pow(p1[0] - p2[0], 2.0) + Math.pow(p1[1] - p2[1], 2.0));
    }
}

