/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nvalue;

import java.util.stream.IntStream;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.tools.ArrayUtils;

public class PropAtLeastNValues
extends Propagator<IntVar> {
    private final int[] concernedValues;
    private final int n;
    private final int[] mate;

    public PropAtLeastNValues(IntVar[] variables, int[] concernedValues, IntVar nValues) {
        super((Variable[])ArrayUtils.concat(variables, nValues), (Priority)PropagatorPriority.QUADRATIC, false);
        this.n = variables.length;
        this.concernedValues = concernedValues;
        this.mate = new int[concernedValues.length];
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[this.n].updateUpperBound(this.n, this);
        int count = 0;
        int countMax = 0;
        for (int i = this.concernedValues.length - 1; i >= 0; --i) {
            boolean possible = false;
            boolean mandatory = false;
            this.mate[i] = -1;
            int value = this.concernedValues[i];
            for (int v = 0; v < this.n; ++v) {
                if (!((IntVar[])this.vars)[v].contains(value)) continue;
                possible = true;
                if (((IntVar[])this.vars)[v].isInstantiated()) {
                    mandatory = true;
                    this.mate[i] = -2;
                    break;
                }
                this.mate[i] = this.mate[i] == -1 ? v : -2;
            }
            if (possible) {
                ++countMax;
            }
            if (!mandatory) continue;
            ++count;
        }
        ((IntVar[])this.vars)[this.n].updateUpperBound(countMax, this);
        boolean again = false;
        if (count < countMax && countMax == ((IntVar[])this.vars)[this.n].getLB()) {
            for (int i = this.concernedValues.length - 1; i >= 0; --i) {
                if (this.mate[i] < 0 || !((IntVar[])this.vars)[this.mate[i]].instantiateTo(this.concernedValues[i], this)) continue;
                again = true;
            }
            if (!again) {
                int i;
                int nbInst = 0;
                for (i = 0; i < this.n; ++i) {
                    if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
                    ++nbInst;
                }
                if (this.n - nbInst == countMax - count) {
                    for (i = this.concernedValues.length - 1; i >= 0; --i) {
                        int v;
                        boolean mandatory = false;
                        int value = this.concernedValues[i];
                        for (v = 0; v < this.n; ++v) {
                            if (!((IntVar[])this.vars)[v].isInstantiatedTo(value)) continue;
                            mandatory = true;
                            break;
                        }
                        if (!mandatory) continue;
                        for (v = 0; v < this.n; ++v) {
                            if (((IntVar[])this.vars)[v].isInstantiated() || !((IntVar[])this.vars)[v].removeValue(value, this)) continue;
                            again = true;
                        }
                    }
                }
            }
        }
        if (count >= ((IntVar[])this.vars)[this.n].getUB()) {
            this.setPassive();
        } else if (again) {
            this.propagate(0);
        }
    }

    @Override
    public ESat isEntailed() {
        int countMin = 0;
        int countMax = 0;
        for (int i = this.concernedValues.length - 1; i >= 0; --i) {
            boolean possible = false;
            boolean mandatory = false;
            for (int v = 0; v < this.n; ++v) {
                if (!((IntVar[])this.vars)[v].contains(this.concernedValues[i])) continue;
                possible = true;
                if (!((IntVar[])this.vars)[v].isInstantiated()) continue;
                mandatory = true;
                break;
            }
            if (possible) {
                ++countMax;
            }
            if (!mandatory) continue;
            ++countMin;
        }
        if (countMin >= ((IntVar[])this.vars)[this.n].getUB()) {
            return ESat.TRUE;
        }
        if (countMax < ((IntVar[])this.vars)[this.n].getLB()) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    private void explainDiffForalliForallt(ExplanationForSignedClause e, int[] indexes) {
        for (int i : indexes) {
            ISetIterator iSetIterator = e.root(((IntVar[])this.vars)[i]).iterator();
            while (iSetIterator.hasNext()) {
                int t = (Integer)iSetIterator.next();
                if (e.domain(((IntVar[])this.vars)[i]).contains(t)) continue;
                ((IntVar[])this.vars)[i].unionLit(t, e);
            }
        }
    }

    private void explainDiffForalliForalltDifft(ExplanationForSignedClause e, int[] indexes, int t) {
        for (int i : indexes) {
            ISetIterator iSetIterator = e.root(((IntVar[])this.vars)[i]).iterator();
            while (iSetIterator.hasNext()) {
                int tt = (Integer)iSetIterator.next();
                if (e.domain(((IntVar[])this.vars)[i]).contains(tt) || t == tt) continue;
                ((IntVar[])this.vars)[i].unionLit(tt, e);
            }
        }
    }

    private void explainDiffForallit(ExplanationForSignedClause e, int[] indexes, int t) {
        for (int i : indexes) {
            if (e.domain(((IntVar[])this.vars)[i]).contains(t)) continue;
            ((IntVar[])this.vars)[i].unionLit(t, e);
        }
    }

    private void explainEquaForalliForalltDifft(ExplanationForSignedClause e, int[] indexes, int t) {
        for (int i : indexes) {
            ISetIterator iSetIterator = e.root(((IntVar[])this.vars)[i]).iterator();
            while (iSetIterator.hasNext()) {
                int tt = (Integer)iSetIterator.next();
                if (!e.domain(((IntVar[])this.vars)[i]).contains(tt) || t == tt) continue;
                ((IntVar[])this.vars)[i].intersectLit(e.setDiffVal(tt), e);
            }
        }
    }

    private void explainEquaForalliForallt(ExplanationForSignedClause e, int[] indexes) {
        for (int i : indexes) {
            ISetIterator iSetIterator = e.root(((IntVar[])this.vars)[i]).iterator();
            while (iSetIterator.hasNext()) {
                int t = (Integer)iSetIterator.next();
                if (!e.domain(((IntVar[])this.vars)[i]).contains(t)) continue;
                ((IntVar[])this.vars)[i].intersectLit(e.setDiffVal(t), e);
            }
        }
    }

    @Override
    public void explain(int p, ExplanationForSignedClause e) {
        IntVar pivot = e.readVar(p);
        int[] X = IntStream.rangeClosed(0, ((IntVar[])this.vars).length - 2).filter(i -> ((IntVar[])this.vars)[i] != pivot).toArray();
        switch (e.readMask(p)) {
            case 4: {
                this.explainDiffForalliForallt(e, X);
                pivot.intersectLit(-1073741823, e.domain(pivot).max(), e);
                break;
            }
            case 8: {
                assert (e.readDom(p).size() == 1);
                int t = e.readDom(p).min();
                this.explainDiffForallit(e, X, t);
                this.explainDiffForalliForalltDifft(e, X, t);
                this.explainEquaForalliForalltDifft(e, X, t);
                ((IntVar[])this.vars)[((IntVar[])this.vars).length - 1].unionLit(e.complement(((IntVar[])this.vars)[((IntVar[])this.vars).length - 1]), e);
                IntIterableRangeSet set = e.complement(pivot);
                set.add(t);
                pivot.intersectLit(set, e);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown event type explanation");
            }
        }
    }
}

