/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.smiles.CxSmilesState;
import org.openscience.cdk.smiles.SmiFlavor;

public class CxSmilesGenerator {
    private static int[] inverse(int[] perm) {
        int[] inv = new int[perm.length];
        int len = perm.length;
        for (int i = 0; i < len; ++i) {
            inv[perm[i]] = i;
        }
        return inv;
    }

    private static String encode_alias(String label) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') {
                sb.append(c);
                continue;
            }
            sb.append("&#").append(Integer.toString(c)).append(";");
        }
        return sb.toString();
    }

    private static int compare(Comparator<Integer> comp, List<Integer> a, List<Integer> b) {
        int alen = a.size();
        int blen = b.size();
        int len = Math.min(alen, blen);
        for (int i = 0; i < len; ++i) {
            int cmp = comp.compare(a.get(i), b.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(alen, blen);
    }

    /*
     * WARNING - void declaration
     */
    static String generate(CxSmilesState state, int opts, int[] components, final int[] ordering) {
        int nonempty_cnt;
        int compId;
        Object compMap;
        if (!SmiFlavor.isSet(opts, 12562688)) {
            return "";
        }
        final int[] invorder = CxSmilesGenerator.inverse(ordering);
        StringBuilder sb = new StringBuilder();
        sb.append(' ');
        sb.append('|');
        Comparator<Integer> invComp = new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return Integer.compare(invorder[a], invorder[b]);
            }
        };
        final Comparator<Integer> comp = new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return Integer.compare(ordering[a], ordering[b]);
            }
        };
        if (SmiFlavor.isSet(opts, 0x100000) && state.fragGroups != null && !state.fragGroups.isEmpty()) {
            void var13_66;
            void var11_36;
            void var13_63;
            int compId2;
            void var11_33;
            int maxCompId = 0;
            int[] nArray = components;
            int n = nArray.length;
            boolean bl = false;
            while (var11_33 < n) {
                compId2 = nArray[var11_33];
                if (compId2 > maxCompId) {
                    maxCompId = compId2;
                }
                ++var11_33;
            }
            compMap = new int[maxCompId + 1];
            compId = 1;
            int[] nArray2 = invorder;
            compId2 = nArray2.length;
            boolean bl2 = false;
            while (var13_63 < compId2) {
                int n2 = nArray2[var13_63];
                int component = components[n2];
                if (compMap[component] == false) {
                    compMap[component] = compId++;
                }
                ++var13_63;
            }
            boolean bl3 = false;
            while (var11_36 < ((Object)compMap).length) {
                Object object = compMap;
                void v1 = var11_36++;
                object[v1] = object[v1] - true;
            }
            final Comparator<Integer> comparator = new Comparator<Integer>((int[])compMap){
                final /* synthetic */ int[] val$compMap;
                {
                    this.val$compMap = nArray;
                }

                @Override
                public int compare(Integer a, Integer b) {
                    return Integer.compare(this.val$compMap[a], this.val$compMap[b]);
                }
            };
            ArrayList<List<Integer>> fragGroupCpy = new ArrayList<List<Integer>>(state.fragGroups);
            for (List list : fragGroupCpy) {
                list.sort(comparator);
            }
            fragGroupCpy.sort(new Comparator<List<Integer>>(){

                @Override
                public int compare(List<Integer> a, List<Integer> b) {
                    return CxSmilesGenerator.compare(comparator, a, b);
                }
            });
            sb.append('f');
            sb.append(':');
            boolean bl4 = false;
            while (var13_66 < fragGroupCpy.size()) {
                if (var13_66 > 0) {
                    sb.append(',');
                }
                CxSmilesGenerator.appendIntegers((int[])compMap, '.', sb, (List)fragGroupCpy.get((int)var13_66));
                ++var13_66;
            }
        }
        if (SmiFlavor.isSet(opts, 32768) && state.atomLabels != null && !state.atomLabels.isEmpty()) {
            void var11_39;
            if (sb.length() > 2) {
                sb.append(',');
            }
            sb.append('$');
            nonempty_cnt = 0;
            compMap = invorder;
            compId = ((int[])compMap).length;
            boolean bl = false;
            while (var11_39 < compId) {
                void var13_69;
                Object idx = compMap[var11_39];
                String string = state.atomLabels.get((int)idx);
                if (string == null || string.isEmpty()) {
                    String string2 = "";
                } else {
                    ++nonempty_cnt;
                }
                sb.append(CxSmilesGenerator.encode_alias((String)var13_69));
                if (nonempty_cnt == state.atomLabels.size()) break;
                sb.append(";");
                ++var11_39;
            }
            sb.append('$');
        }
        if (SmiFlavor.isSet(opts, 65536) && state.atomValues != null && !state.atomValues.isEmpty()) {
            void var11_41;
            if (sb.length() > 2) {
                sb.append(',');
            }
            sb.append("$_AV:");
            nonempty_cnt = 0;
            compMap = invorder;
            compId = ((int[])compMap).length;
            boolean bl = false;
            while (var11_41 < compId) {
                void var13_72;
                Object idx = compMap[var11_41];
                String string = state.atomValues.get((int)idx);
                if (string == null || string.isEmpty()) {
                    String string3 = "";
                } else {
                    ++nonempty_cnt;
                }
                sb.append(CxSmilesGenerator.encode_alias((String)var13_72));
                if (nonempty_cnt == state.atomValues.size()) break;
                sb.append(";");
                ++var11_41;
            }
            sb.append('$');
        }
        if (SmiFlavor.isFullySet(opts, 0x800100)) {
            if (state.racemic) {
                if (sb.length() > 2) {
                    sb.append(',');
                }
                sb.append("r");
            } else {
                if (state.racemicFrags != null) {
                    if (sb.length() > 2) {
                        sb.append(',');
                    }
                    sb.append("r:");
                    sb.append(state.racemicFrags.get(0));
                    for (int i = 1; i < state.racemicFrags.size(); ++i) {
                        sb.append(',').append(state.racemicFrags.get(i));
                    }
                }
                if (state.stereoGrps != null) {
                    TreeMap<Integer, List> grpToIdxs = new TreeMap<Integer, List>();
                    compMap = state.stereoGrps.entrySet().iterator();
                    while (compMap.hasNext()) {
                        Map.Entry e = (Map.Entry)compMap.next();
                        Integer n = (Integer)e.getKey();
                        Integer grp = (Integer)e.getValue();
                        grpToIdxs.computeIfAbsent(grp, k -> new ArrayList()).add(n);
                    }
                    ArrayList entries = new ArrayList(grpToIdxs.entrySet());
                    for (Map.Entry entry : entries) {
                        ((List)entry.getValue()).sort(invComp);
                    }
                    entries.sort((o1, o2) -> invComp.compare((Integer)((List)o1.getValue()).get(0), (Integer)((List)o2.getValue()).get(0)));
                    int numRac = 0;
                    boolean bl = false;
                    for (Map.Entry entry : entries) {
                        if (sb.length() > 2) {
                            sb.append(',');
                        }
                        int n = (Integer)entry.getKey();
                        switch (n & 0x30000) {
                            case 0: {
                                sb.append("a");
                                break;
                            }
                            case 65536: {
                                sb.append("&");
                                sb.append(++numRac);
                                break;
                            }
                            case 131072: {
                                void var11_45;
                                sb.append("o");
                                sb.append((int)(++var11_45));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected stereo group");
                            }
                        }
                        sb.append(":");
                        CxSmilesGenerator.appendIntegers(invorder, ',', sb, (List)entry.getValue());
                    }
                }
            }
        }
        if (SmiFlavor.isSet(opts, 12288) && state.atomCoords != null && !state.atomCoords.isEmpty()) {
            DecimalFormat fmt = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ROOT));
            if (sb.length() > 2) {
                sb.append(',');
            }
            sb.append('(');
            for (int i = 0; i < ordering.length; ++i) {
                double[] xyz = state.atomCoords.get(invorder[i]);
                if (i != 0) {
                    sb.append(';');
                }
                if (xyz[0] != 0.0) {
                    sb.append(fmt.format(xyz[0]));
                }
                sb.append(',');
                if (xyz[1] != 0.0) {
                    sb.append(fmt.format(xyz[1]));
                }
                sb.append(',');
                if (xyz[2] == 0.0) continue;
                sb.append(fmt.format(xyz[2]));
            }
            sb.append(')');
        }
        if (SmiFlavor.isSet(opts, 262144) && state.positionVar != null && !state.positionVar.isEmpty()) {
            if (sb.length() > 2) {
                sb.append(',');
            }
            sb.append('m');
            sb.append(':');
            ArrayList<Map.Entry<Integer, List<Integer>>> multicenters = new ArrayList<Map.Entry<Integer, List<Integer>>>(state.positionVar.entrySet());
            multicenters.sort((a, b) -> comp.compare((Integer)a.getKey(), (Integer)b.getKey()));
            for (int i = 0; i < multicenters.size(); ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                Map.Entry e = (Map.Entry)multicenters.get(i);
                sb.append(ordering[(Integer)e.getKey()]);
                sb.append(':');
                ArrayList<Integer> arrayList = new ArrayList<Integer>((Collection)e.getValue());
                arrayList.sort(comp);
                CxSmilesGenerator.appendIntegers(ordering, '.', sb, arrayList);
            }
        }
        if (SmiFlavor.isSet(opts, 0x200000) && state.ligandOrdering != null && !state.ligandOrdering.isEmpty()) {
            if (sb.length() > 2) {
                sb.append(',');
            }
            sb.append("LO");
            sb.append(':');
            ArrayList<Map.Entry<Integer, List<Integer>>> ligandorderings = new ArrayList<Map.Entry<Integer, List<Integer>>>(state.ligandOrdering.entrySet());
            ligandorderings.sort((a, b) -> comp.compare((Integer)a.getKey(), (Integer)b.getKey()));
            for (int i = 0; i < ligandorderings.size(); ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                Map.Entry e = (Map.Entry)ligandorderings.get(i);
                sb.append(ordering[(Integer)e.getKey()]);
                sb.append(':');
                CxSmilesGenerator.appendIntegers(ordering, '.', sb, (List)e.getValue());
            }
        }
        int numSgroups = 0;
        if (SmiFlavor.isSet(opts, 524288) && state.mysgroups != null && !state.mysgroups.isEmpty()) {
            ArrayList<CxSmilesState.CxPolymerSgroup> polysgroups = new ArrayList<CxSmilesState.CxPolymerSgroup>();
            for (CxSmilesState.CxSgroup cxSgroup : state.mysgroups) {
                if (!(cxSgroup instanceof CxSmilesState.CxPolymerSgroup)) continue;
                polysgroups.add((CxSmilesState.CxPolymerSgroup)cxSgroup);
                cxSgroup.atoms.sort(comp);
            }
            polysgroups.sort(new Comparator<CxSmilesState.CxPolymerSgroup>(){

                @Override
                public int compare(CxSmilesState.CxPolymerSgroup a, CxSmilesState.CxPolymerSgroup b) {
                    int cmp = a.type.compareTo(b.type);
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = CxSmilesGenerator.compare(comp, a.atoms, b.atoms);
                    return cmp;
                }
            });
            for (CxSmilesState.CxPolymerSgroup cxPolymerSgroup : polysgroups) {
                cxPolymerSgroup.id = numSgroups++;
                if (sb.length() > 2) {
                    sb.append(',');
                }
                sb.append("Sg:");
                sb.append(cxPolymerSgroup.type);
                sb.append(':');
                CxSmilesGenerator.appendIntegers(ordering, ',', sb, cxPolymerSgroup.atoms);
                sb.append(':');
                if (cxPolymerSgroup.subscript != null) {
                    sb.append(cxPolymerSgroup.subscript);
                }
                sb.append(':');
                if (cxPolymerSgroup.supscript == null) continue;
                sb.append(cxPolymerSgroup.supscript.toLowerCase(Locale.ROOT));
            }
        }
        if (SmiFlavor.isSet(opts, 0x400000) && state.mysgroups != null && !state.mysgroups.isEmpty()) {
            ArrayList<CxSmilesState.CxDataSgroup> datasgroups = new ArrayList<CxSmilesState.CxDataSgroup>();
            for (CxSmilesState.CxSgroup cxSgroup : state.mysgroups) {
                if (!(cxSgroup instanceof CxSmilesState.CxDataSgroup)) continue;
                datasgroups.add((CxSmilesState.CxDataSgroup)cxSgroup);
                cxSgroup.atoms.sort(comp);
            }
            datasgroups.sort(new Comparator<CxSmilesState.CxDataSgroup>(){

                @Override
                public int compare(CxSmilesState.CxDataSgroup a, CxSmilesState.CxDataSgroup b) {
                    int cmp = a.field.compareTo(b.field);
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = a.value.compareTo(b.value);
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = CxSmilesGenerator.compare(comp, a.atoms, b.atoms);
                    return cmp;
                }
            });
            for (CxSmilesState.CxDataSgroup cxDataSgroup : datasgroups) {
                cxDataSgroup.id = numSgroups++;
                if (sb.length() > 2) {
                    sb.append(',');
                }
                sb.append("SgD:");
                CxSmilesGenerator.appendIntegers(ordering, ',', sb, cxDataSgroup.atoms);
                sb.append(':');
                if (cxDataSgroup.field != null) {
                    sb.append(cxDataSgroup.field);
                }
                sb.append(':');
                if (cxDataSgroup.value != null) {
                    sb.append(cxDataSgroup.value);
                }
                sb.append(':');
                if (cxDataSgroup.operator != null) {
                    sb.append(cxDataSgroup.operator);
                }
                sb.append(':');
                if (cxDataSgroup.unit == null) continue;
                sb.append(cxDataSgroup.unit);
            }
        }
        if (numSgroups > 0) {
            boolean firstSgH = true;
            if (state.mysgroups != null) {
                state.mysgroups.sort(Comparator.comparingInt(o -> o.id));
                for (CxSmilesState.CxSgroup cxSgroup : state.mysgroups) {
                    if (cxSgroup.children.isEmpty()) continue;
                    if (sb.length() > 2) {
                        sb.append(',');
                    }
                    if (firstSgH) {
                        sb.append("SgH:");
                        firstSgH = false;
                    }
                    sb.append(cxSgroup.id).append(':');
                    boolean first = true;
                    ArrayList<CxSmilesState.CxSgroup> arrayList = new ArrayList<CxSmilesState.CxSgroup>(cxSgroup.children);
                    arrayList.sort(Comparator.comparingInt(o -> o.id));
                    for (CxSmilesState.CxSgroup child : arrayList) {
                        if (child.id < 0) continue;
                        if (!first) {
                            sb.append('.');
                        }
                        first = false;
                        sb.append(child.id);
                    }
                }
            }
        }
        if (SmiFlavor.isSet(opts, 131072) && state.atomRads != null && !state.atomRads.isEmpty()) {
            TreeMap<CxSmilesState.Radical, ArrayList<Integer>> radinv = new TreeMap<CxSmilesState.Radical, ArrayList<Integer>>();
            for (Map.Entry<Integer, CxSmilesState.Radical> entry : state.atomRads.entrySet()) {
                ArrayList<Integer> idxs = (ArrayList<Integer>)radinv.get((Object)entry.getValue());
                if (idxs == null) {
                    idxs = new ArrayList<Integer>();
                    radinv.put(entry.getValue(), idxs);
                }
                idxs.add(entry.getKey());
            }
            for (Map.Entry<Integer, CxSmilesState.Radical> entry : radinv.entrySet()) {
                if (sb.length() > 2) {
                    sb.append(',');
                }
                sb.append('^');
                sb.append(((CxSmilesState.Radical)((Object)entry.getKey())).ordinal() + 1);
                sb.append(':');
                ((List)((Object)entry.getValue())).sort(comp);
                CxSmilesGenerator.appendIntegers(ordering, ',', sb, (List)((Object)entry.getValue()));
            }
        }
        sb.append('|');
        if (sb.length() <= 3) {
            return "";
        }
        return sb.toString();
    }

    private static void appendIntegers(int[] invorder, char sep, StringBuilder sb, List<Integer> vals) {
        Iterator<Integer> iter = vals.iterator();
        if (iter.hasNext()) {
            sb.append(invorder[iter.next()]);
            while (iter.hasNext()) {
                sb.append(sep);
                sb.append(invorder[iter.next()]);
            }
        }
    }
}

