/*
 * Decompiled with CFR 0.152.
 */
package com.r2pmml;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.dmg.pmml.PMML;
import org.jpmml.converter.Application;
import org.jpmml.model.metro.MetroJAXBUtil;
import org.jpmml.rexp.Converter;
import org.jpmml.rexp.ConverterFactory;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpParser;

public class Main
extends Application {
    @Parameter(names={"--converter"}, description="Converter class")
    private String converter = null;
    @Parameter(names={"--model-rds-input", "--rds-input"}, required=true)
    private File inputFile = null;
    @Parameter(names={"--pmml-output"}, required=true)
    private File outputFile = null;

    public static void main(String ... args) throws Exception {
        Main application = new Main();
        JCommander commander = JCommander.newBuilder().addObject((Object)application).build();
        commander.parse(args);
        try {
            Application.setInstance((Application)application);
            application.run();
        }
        finally {
            Application.setInstance(null);
        }
    }

    public void run() throws Exception {
        File absoluteOutputFile;
        File outputDir;
        Converter converter;
        RExp rexp;
        try (FileInputStream is = new FileInputStream(this.inputFile);){
            RExpParser parser = new RExpParser((InputStream)is);
            rexp = parser.parse();
        }
        ConverterFactory converterFactory = ConverterFactory.newInstance();
        if (this.converter != null) {
            Class<?> clazz = Class.forName(this.converter);
            converter = converterFactory.newConverter(clazz, rexp);
        } else {
            converter = converterFactory.newConverter(rexp);
        }
        PMML pmml = converter.encodePMML();
        if (!this.outputFile.exists() && !(outputDir = (absoluteOutputFile = this.outputFile.getAbsoluteFile()).getParentFile()).exists()) {
            outputDir.mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(this.outputFile);){
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
        }
    }
}

